/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ResIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static StmtIterator asStmtIterator(Iterator<Triple> i2, final ModelCom m3) {
        Map1<Triple, Statement> asStatement = new Map1<Triple, Statement>(){

            @Override
            public Statement map1(Triple t) {
                return m3.asStatement(t);
            }
        };
        return new StmtIteratorImpl((Iterator<Statement>)WrappedIterator.create(i2).mapWith(asStatement));
    }

    public static ResIterator asResIterator(Iterator<Node> i2, final ModelCom m3) {
        Map1<Node, Resource> asResource = new Map1<Node, Resource>(){

            @Override
            public Resource map1(Node o) {
                return (Resource)m3.asRDFNode(o);
            }
        };
        return new ResIteratorImpl(WrappedIterator.create(i2).mapWith(asResource), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator<Node> i2, final ModelCom m3) {
        Map1<Node, RDFNode> asRDFNode = new Map1<Node, RDFNode>(){

            @Override
            public RDFNode map1(Node o) {
                return m3.asRDFNode(o);
            }
        };
        return new NodeIteratorImpl(WrappedIterator.create(i2).mapWith(asRDFNode), null);
    }

    static Resource asResource(Node n, ModelCom m3) {
        return IteratorFactory.asResource(n, Resource.class, m3);
    }

    static Property asProperty(Node n, ModelCom m3) {
        return (Property)IteratorFactory.asResource(n, Property.class, m3);
    }

    static Literal asLiteral(Node n, ModelCom m3) {
        return m3.getNodeAs(n, Literal.class);
    }

    static <X extends RDFNode> Resource asResource(Node n, Class<X> cl, ModelCom m3) {
        return (Resource)m3.getNodeAs(n, cl);
    }
}

