/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.shared.CannotEncodeCharacterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.util.XMLChar;

public class Util {
    protected static Pattern standardEntities = Pattern.compile("&|<|>|\t|\n|\r|'|\"");
    protected static Pattern entityValueEntities = Pattern.compile("&|%|'|\"");
    protected static Pattern elementContentEntities = Pattern.compile("<|>|&|[\u0000-\u001f&&[^\n\t]]|\uffff|\ufffe");

    public static int splitNamespace(String uri) {
        char ch;
        int i2;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        for (i2 = lg - 1; i2 >= 1 && !Util.notNameChar(ch = uri.charAt(i2)); --i2) {
        }
        int j = i2 + 1;
        if (j >= lg) {
            return lg;
        }
        if (j >= 2 && uri.charAt(j - 2) == '%') {
            ++j;
        }
        if (j >= 1 && uri.charAt(j - 1) == '%') {
            j += 2;
        }
        while (j < lg && (!XMLChar.isNCNameStart(ch = uri.charAt(j)) || j == 7 && uri.startsWith("mailto:"))) {
            ++j;
        }
        return j;
    }

    public static boolean notNameChar(char ch) {
        return !XMLChar.isNCName(ch);
    }

    public static String substituteStandardEntities(String s2) {
        if (standardEntities.matcher(s2).find()) {
            return Util.substituteEntitiesInElementContent(s2).replaceAll("'", "&apos;").replaceAll("\t", "&#9;").replaceAll("\n", "&#xA;").replaceAll("\r", "&#xD;").replaceAll("\"", "&quot;");
        }
        return s2;
    }

    public static String substituteEntitiesInEntityValue(String s2) {
        if (entityValueEntities.matcher(s2).find()) {
            return s2.replaceAll("&", "&amp;").replaceAll("'", "&apos;").replaceAll("%", "&#37;").replaceAll("\"", "&quot;");
        }
        return s2;
    }

    public static String substituteEntitiesInElementContent(String s2) {
        Matcher m3 = elementContentEntities.matcher(s2);
        if (!m3.find()) {
            return s2;
        }
        int start = 0;
        StringBuilder result = new StringBuilder();
        do {
            result.append(s2.substring(start, m3.start()));
            char ch = s2.charAt(m3.start());
            switch (ch) {
                case '\r': {
                    result.append("&#xD;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                default: {
                    throw new CannotEncodeCharacterException(ch, "XML");
                }
            }
        } while (m3.find(start = m3.end()));
        result.append(s2.substring(start));
        return result.toString();
    }

    public static String replace(String s2, String oldString, String newString) {
        String result = "";
        int length = oldString.length();
        int pos = s2.indexOf(oldString);
        int lastPos = 0;
        while (pos >= 0) {
            result = result + s2.substring(lastPos, pos) + newString;
            lastPos = pos + length;
            pos = s2.indexOf(oldString, lastPos);
        }
        return result + s2.substring(lastPos, s2.length());
    }

    public static String XgetProperty(String p) {
        return Util.XgetProperty(p, null);
    }

    public static String XgetProperty(String p, String def) {
        try {
            return System.getProperty(p, def);
        }
        catch (SecurityException e2) {
            return def;
        }
    }
}

