/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput;

import com.hp.hpl.jena.rdfxml.xmlinput.ARPErrorNumbers;
import org.apache.jena.iri.IRIFactory;

public class ARPOptions
implements ARPErrorNumbers {
    private static int[] defaultErrorMode = new int[400];
    private boolean embedding = false;
    private int[] errorMode = (int[])defaultErrorMode.clone();
    private static IRIFactory defaultIriFactory;
    private IRIFactory iriFactory = defaultIriFactory;

    private ARPOptions() {
    }

    public static ARPOptions createNewOptions() {
        return new ARPOptions();
    }

    public int setErrorMode(int errno, int mode) {
        int old = this.errorMode[errno];
        this.errorMode[errno] = mode;
        return old;
    }

    public void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    public void setLaxErrorMode() {
        this.setDefaultErrorMode();
        for (int i2 = 100; i2 < 200; ++i2) {
            this.setErrorMode(i2, 0);
        }
    }

    public void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    public void setStrictErrorMode(int nonErrorMode) {
        this.setDefaultErrorMode();
        for (int i2 = 1; i2 < 100; ++i2) {
            this.setErrorMode(i2, nonErrorMode);
        }
        int warning = 1;
        int error = 2;
        switch (nonErrorMode) {
            case 2: {
                warning = 2;
                break;
            }
            case 3: {
                error = 3;
                warning = 3;
            }
        }
        for (int i3 = 100; i3 < 200; ++i3) {
            this.setErrorMode(i3, error);
        }
        this.setErrorMode(117, warning);
        this.setErrorMode(131, warning);
        this.setErrorMode(106, warning);
        this.setErrorMode(119, nonErrorMode);
        this.setErrorMode(114, nonErrorMode);
        this.setErrorMode(113, warning);
        this.setErrorMode(103, warning);
        this.setErrorMode(101, warning);
        this.setErrorMode(118, nonErrorMode);
        this.setErrorMode(135, nonErrorMode);
        this.setErrorMode(126, warning);
    }

    public ARPOptions copy() {
        ARPOptions rslt = new ARPOptions();
        rslt.errorMode = (int[])this.errorMode.clone();
        rslt.embedding = this.embedding;
        return rslt;
    }

    public boolean setEmbedding(boolean embed) {
        boolean old = this.embedding;
        this.embedding = embed;
        return old;
    }

    public int getErrorMode(int eCode) {
        return this.errorMode[eCode];
    }

    public boolean getEmbedding() {
        return this.embedding;
    }

    public void setIRIFactory(IRIFactory f) {
        this.iriFactory = f;
    }

    public IRIFactory getIRIFactory() {
        return this.iriFactory;
    }

    public static void setIRIFactoryGlobal(IRIFactory f) {
        defaultIriFactory = f;
    }

    public static IRIFactory getIRIFactoryGlobal() {
        return defaultIriFactory;
    }

    static {
        for (int i2 = 0; i2 < defaultErrorMode.length; ++i2) {
            ARPOptions.defaultErrorMode[i2] = i2 / 100;
        }
        defaultIriFactory = IRIFactory.jenaImplementation();
    }
}

