/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput.states;

import com.hp.hpl.jena.rdfxml.xmlinput.ARPErrorNumbers;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.ARPString;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.AbsXMLContext;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.AttributeLexer;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.ElementLexer;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.Names;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.ParserSupport;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.QNameLexer;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.Taint;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.TaintImpl;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.URIReference;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.states.FrameI;
import com.hp.hpl.jena.rdfxml.xmlinput.states.HasSubjectFrameI;
import com.hp.hpl.jena.rdfxml.xmlinput.states.LookingForRDF;
import com.hp.hpl.jena.rdfxml.xmlinput.states.WantTopLevelDescription;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public abstract class Frame
extends ParserSupport
implements Names,
FrameI,
ARPErrorNumbers {
    final FrameI parent;
    protected boolean nonWhiteMsgGiven = false;
    public Taint taint = new TaintImpl();

    @Override
    public FrameI getParent() {
        return this.parent;
    }

    public Frame(FrameI p, AttributeLexer ap) throws SAXParseException {
        super(p.getXMLHandler(), ap.xml(p.getXMLContext()));
        this.parent = p;
    }

    public Frame(FrameI p, AbsXMLContext x) {
        super(p.getXMLHandler(), x);
        this.parent = p;
    }

    public Frame(XMLHandler a, AbsXMLContext x) {
        super(a, x);
        this.parent = null;
    }

    protected void warning(int i2, String msg) throws SAXParseException {
        this.warning(this.taint, i2, msg);
    }

    @Override
    public void afterChild() {
        this.taint = new TaintImpl();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXParseException {
    }

    @Override
    public void endElement() throws SAXParseException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXParseException {
        this.warning(null, 119, "A processing instruction is in RDF content. No processing was done. " + this.suggestParsetypeLiteral());
    }

    void processPropertyAttributes(AttributeLexer ap, Attributes atts, AbsXMLContext x) throws SAXParseException {
        int sz;
        if (ap.type != null) {
            ((HasSubjectFrameI)((Object)this)).aPredAndObj(RDF_TYPE, URIReference.resolve(this, x, ap.type));
        }
        if (ap.count != (sz = atts.getLength())) {
            for (int i2 = 0; i2 < sz; ++i2) {
                if (ap.done(i2)) continue;
                String uri = atts.getURI(i2);
                String lName = atts.getLocalName(i2);
                URIReference pred = URIReference.fromQName(this, uri, lName);
                if (uri == null || uri.equals("")) {
                    this.warning(pred, 102, "Unqualified property attributes are not allowed. Property treated as a relative URI.");
                }
                if (rdfns.equals(uri) && !QNameLexer.isKnownRDFProperty(lName)) {
                    this.warning(pred, 103, atts.getQName(i2) + " is not a recognized RDF property or type.");
                }
                ((HasSubjectFrameI)((Object)this)).aPredAndObj(pred, new ARPString(this, atts.getValue(i2), x));
            }
        }
    }

    @Override
    public void abort() {
    }

    protected FrameI rdfStartElement(String uri, String localName, String rawName, Attributes atts) throws SAXParseException {
        ElementLexer el = new ElementLexer(this.taint, this, uri, localName, rawName, 4096, 0, false);
        if (el.goodMatch) {
            AttributeLexer ap = new AttributeLexer(this, 7, 0);
            if (ap.processSpecials(this.taint, atts) != atts.getLength()) {
                this.warning(201, "Illegal attributes on rdf:RDF");
            }
            this.arp.startRDF();
            return new WantTopLevelDescription((FrameI)this, ap);
        }
        AttributeLexer ap = new AttributeLexer(this, 3, 0);
        ap.processSpecials(this.taint, atts);
        return new LookingForRDF((FrameI)this, ap);
    }

    String suggestParsetypeLiteral() {
        return " Maybe there should be an rdf:parseType='Literal' for embedding mixed XML content in RDF.";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXParseException {
        if (!this.nonWhiteMsgGiven && !this.isWhite(ch, start, length)) {
            this.nonWhiteMsgGiven = true;
            this.warning(202, "Expecting XML start or end element(s). String data \"" + new String(ch, start, length) + "\" not allowed." + this.suggestParsetypeLiteral() + " Maybe a striping error.");
        }
    }
}

