/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.shared.JenaException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.xerces.impl.dv.util.Base64;

public class MakeSkolem
extends BaseBuiltin {
    @Override
    public String getName() {
        return "makeSkolem";
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        StringBuilder key = new StringBuilder();
        for (int i2 = 1; i2 < length; ++i2) {
            Node n = this.getArg(i2, args, context);
            if (n.isBlank()) {
                key.append("B");
                key.append(n.getBlankNodeLabel());
                continue;
            }
            if (n.isURI()) {
                key.append("U");
                key.append(n.getURI());
                continue;
            }
            if (n.isLiteral()) {
                key.append("L");
                key.append(n.getLiteralLexicalForm());
                if (n.getLiteralLanguage() != null) {
                    key.append("@" + n.getLiteralLanguage());
                }
                if (n.getLiteralDatatypeURI() == null) continue;
                key.append("^^" + n.getLiteralDatatypeURI());
                continue;
            }
            key.append("O");
            key.append(n.toString());
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            digester.reset();
            byte[] digest = digester.digest(key.toString().getBytes());
            Node skolem = NodeFactory.createAnon(new AnonId(Base64.encode(digest)));
            return context.getEnv().bind(args[0], skolem);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new JenaException(e2);
        }
    }
}

