/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import java.util.List;

public class TransformMergeBGPs
extends TransformCopy {
    @Override
    public Op transform(OpJoin opJoin, Op left, Op right) {
        BasicPattern p1 = TransformMergeBGPs.asBGP(left);
        BasicPattern p2 = TransformMergeBGPs.asBGP(right);
        if (p1 != null && p2 != null) {
            BasicPattern p = TransformMergeBGPs.merge(p1, p2);
            return new OpBGP(p);
        }
        return super.transform(opJoin, left, right);
    }

    @Override
    public Op transform(OpSequence opSequence, List<Op> elts) {
        boolean xform = false;
        boolean previousBGP = false;
        for (Op op1 : elts) {
            BasicPattern p1 = TransformMergeBGPs.asBGP(op1);
            if (previousBGP && p1 != null) {
                xform = true;
                break;
            }
            previousBGP = p1 != null;
        }
        if (!xform) {
            return super.transform(opSequence, elts);
        }
        OpSequence seq2 = OpSequence.create();
        block1: for (int i2 = 0; i2 < elts.size(); ++i2) {
            Op op = elts.get(i2);
            BasicPattern p1 = TransformMergeBGPs.asBGP(op);
            if (p1 == null) {
                seq2.add(op);
                continue;
            }
            BasicPattern pMerge = new BasicPattern();
            seq2.add(new OpBGP(pMerge));
            while (i2 < elts.size()) {
                Op opNext = elts.get(i2);
                BasicPattern p2 = TransformMergeBGPs.asBGP(opNext);
                if (p2 == null) {
                    seq2.add(opNext);
                    continue block1;
                }
                pMerge.addAll(p2);
                ++i2;
            }
        }
        if (seq2.size() == 1) {
            return seq2.get(0);
        }
        return seq2;
    }

    private static BasicPattern asBGP(Op op) {
        if (op instanceof OpBGP) {
            return ((OpBGP)op).getPattern();
        }
        return null;
    }

    private static BasicPattern merge(BasicPattern p1, BasicPattern p2) {
        if (p1 == null || p2 == null) {
            return null;
        }
        BasicPattern p = new BasicPattern();
        p.addAll(p1);
        p.addAll(p2);
        return p;
    }
}

