/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcessBinding;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.atlas.io.IndentedWriter;

public class QueryIterAssignVarValue
extends QueryIterProcessBinding {
    private final Var var;
    private final Node node;
    private final boolean mustBeNewVar;

    public QueryIterAssignVarValue(QueryIterator input, Var var, Node node, ExecutionContext qCxt) {
        this(input, var, node, qCxt, false);
    }

    public QueryIterAssignVarValue(QueryIterator input, Var var, Node node, ExecutionContext qCxt, boolean mustBeNewVar) {
        super(input, qCxt);
        this.var = var;
        this.node = node;
        this.mustBeNewVar = mustBeNewVar;
    }

    @Override
    public Binding accept(Binding binding) {
        if (binding.contains(this.var)) {
            if (this.mustBeNewVar) {
                throw new QueryExecException("Already set: " + this.var);
            }
            Node n2 = binding.get(this.var);
            if (!n2.equals(this.node)) {
                return null;
            }
        }
        return BindingFactory.binding(binding, this.var, this.node);
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ?" + this.var.toString() + " = " + FmtUtils.stringForNode(this.node, cxt));
    }
}

