/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction0;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunction3;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.List;

public class ExprTransformCopy
implements ExprTransform {
    public static final boolean COPY_ALWAYS = true;
    public static final boolean COPY_ONLY_ON_CHANGE = false;
    private boolean alwaysCopy = false;

    public ExprTransformCopy() {
        this(false);
    }

    public ExprTransformCopy(boolean alwaysDuplicate) {
        this.alwaysCopy = alwaysDuplicate;
    }

    @Override
    public Expr transform(ExprFunction0 func) {
        return this.xform(func);
    }

    @Override
    public Expr transform(ExprFunction1 func, Expr expr1) {
        return this.xform(func, expr1);
    }

    @Override
    public Expr transform(ExprFunction2 func, Expr expr1, Expr expr2) {
        return this.xform(func, expr1, expr2);
    }

    @Override
    public Expr transform(ExprFunction3 func, Expr expr1, Expr expr2, Expr expr3) {
        return this.xform(func, expr1, expr2, expr3);
    }

    @Override
    public Expr transform(ExprFunctionN func, ExprList args) {
        return this.xform(func, args);
    }

    @Override
    public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        return this.xform(funcOp, args, opArg);
    }

    @Override
    public Expr transform(NodeValue nv) {
        return this.xform(nv);
    }

    @Override
    public Expr transform(ExprVar exprVar) {
        return this.xform(exprVar);
    }

    @Override
    public Expr transform(ExprAggregator eAgg) {
        return this.xform(eAgg);
    }

    private Expr xform(ExprFunction0 func) {
        if (!this.alwaysCopy) {
            return func;
        }
        return func.copy();
    }

    private Expr xform(ExprFunction1 func, Expr expr1) {
        if (!this.alwaysCopy && expr1 == func.getArg()) {
            return func;
        }
        return func.copy(expr1);
    }

    private Expr xform(ExprFunction2 func, Expr expr1, Expr expr2) {
        if (!this.alwaysCopy && expr1 == func.getArg1() && expr2 == func.getArg2()) {
            return func;
        }
        return func.copy(expr1, expr2);
    }

    private Expr xform(ExprFunction3 func, Expr expr1, Expr expr2, Expr expr3) {
        if (!this.alwaysCopy && expr1 == func.getArg1() && expr2 == func.getArg2() && expr3 == func.getArg3()) {
            return func;
        }
        return func.copy(expr1, expr2, expr3);
    }

    private Expr xform(ExprFunctionN func, ExprList args) {
        if (!this.alwaysCopy && this.equals1(func.getArgs(), args.getList())) {
            return func;
        }
        return func.copy(args);
    }

    private boolean equals1(List<Expr> list1, List<Expr> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null) {
            return false;
        }
        if (list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list1.size(); ++i2) {
            if (list1.get(i2) == list2.get(i2)) continue;
            return false;
        }
        return true;
    }

    private Expr xform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        if (!this.alwaysCopy && this.equals1(funcOp.getArgs(), args.getList()) && funcOp.getGraphPattern() == opArg) {
            return funcOp;
        }
        return funcOp.copy(args, opArg);
    }

    private Expr xform(NodeValue nv) {
        return nv;
    }

    private Expr xform(ExprVar exprVar) {
        return exprVar;
    }

    private Expr xform(ExprAggregator eAgg) {
        if (!this.alwaysCopy) {
            return eAgg;
        }
        return eAgg.copy(eAgg.getVar());
    }
}

