/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library.leviathan;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionBase1;
import java.math.BigInteger;

public class cube
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("cube", v)) {
            case OP_INTEGER: {
                BigInteger i2 = v.getInteger();
                return NodeValue.makeInteger(i2.pow(3));
            }
            case OP_DECIMAL: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.pow(dec, 3.0));
            }
            case OP_FLOAT: 
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.pow(v.getDouble(), 3.0));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }
}

