/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.logging.FmtLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVInput {
    private static Logger log = LoggerFactory.getLogger(CSVInput.class);

    public static ResultSet fromCSV(InputStream in) {
        CSVParser parser = CSVParser.create(in);
        final List<Var> vars = CSVInput.vars(parser);
        List<String> varNames = Var.varNames(vars);
        Transform<List<String>, Binding> transform = new Transform<List<String>, Binding>(){
            private int count = 1;

            @Override
            public Binding convert(List<String> row) {
                if (row.size() != vars.size()) {
                    FmtLog.warn(log, "Row %d: Length=%d: expected=%d", this.count, row.size(), vars.size());
                }
                BindingMap binding = BindingFactory.create();
                for (int i2 = 0; i2 < vars.size(); ++i2) {
                    Var v = (Var)vars.get(i2);
                    String field = i2 < row.size() ? row.get(i2) : "";
                    Node n = NodeFactory.createLiteral(field);
                    binding.add(v, n);
                }
                ++this.count;
                return binding;
            }
        };
        Iterator<Binding> bindings2 = Iter.map(parser, transform);
        return new ResultSetStream(varNames, null, bindings2);
    }

    private static List<Var> vars(CSVParser parser) {
        ArrayList<Var> vars = new ArrayList<Var>();
        List<String> varNames = parser.parse1();
        if (varNames == null) {
            throw new ARQException("SPARQL CSV Results malformed, input is empty");
        }
        for (String vn : varNames) {
            vars.add(Var.alloc(vn));
        }
        return vars;
    }

    public static boolean booleanFromCSV(InputStream in) {
        boolean b;
        List<String> line;
        CSVParser parser = CSVParser.create(in);
        List<Var> vars = CSVInput.vars(parser);
        if (vars.size() != 1) {
            throw new ARQException("CSV Boolean Results malformed: variables line='" + vars + "'");
        }
        if (!vars.get(0).getName().equals("_askResult")) {
            FmtLog.warn(log, "Boolean result variable is '%s', not '_askResult'", vars.get(0).getName());
        }
        if ((line = parser.parse1()).size() != 1) {
            throw new ARQException("CSV Boolean Results malformed: data line='" + line + "'");
        }
        String str2 = line.get(0);
        if (str2.equalsIgnoreCase("true") || str2.equalsIgnoreCase("yes")) {
            b = true;
        } else if (str2.equalsIgnoreCase("false") || str2.equalsIgnoreCase("no")) {
            b = false;
        } else {
            throw new ARQException("CSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        List<String> line2 = parser.parse1();
        if (line2 != null) {
            FmtLog.warn(log, "Extra rows: first is " + line2, new Object[0]);
        }
        return b;
    }
}

