/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.model.Inventory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class SidecarMapper {
    private SidecarMapper() {
    }

    public static void writeSidecar(Inventory inventory, String digest, Path dstDirectory) {
        try {
            Path sidecarPath = ObjectPaths.inventorySidecarPath(dstDirectory, inventory);
            Files.writeString(sidecarPath, (CharSequence)(digest + "\tinventory.json"), new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static String readDigest(Path sidecarPath) {
        if (Files.notExists(sidecarPath, new LinkOption[0])) {
            throw new CorruptObjectException("Inventory sidecar does not exist at " + sidecarPath);
        }
        try {
            String[] parts = Files.readString(sidecarPath).split("\\s+");
            if (parts.length != 2) {
                throw new CorruptObjectException("Invalid inventory sidecar file: " + sidecarPath);
            }
            return parts[0];
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static DigestAlgorithm getDigestAlgorithmFromSidecar(String inventorySidecarPath) {
        String value = Paths.get(inventorySidecarPath, new String[0]).getFileName().toString().substring("inventory.json".length() + 1);
        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm(value);
        if (!OcflConstants.ALLOWED_DIGEST_ALGORITHMS.contains(algorithm)) {
            throw new CorruptObjectException(String.format("Inventory sidecar at <%s> specifies digest algorithm %s. Allowed algorithms are: %s", inventorySidecarPath, value, OcflConstants.ALLOWED_DIGEST_ALGORITHMS));
        }
        return algorithm;
    }
}

