/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.cache.Cache;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.storage.AbstractOcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;

public class CachingOcflStorage
extends AbstractOcflStorage {
    private final Cache<String, Inventory> inventoryCache;
    private final OcflStorage delegate;

    public CachingOcflStorage(Cache<String, Inventory> inventoryCache, OcflStorage delegate) {
        this.inventoryCache = Enforce.notNull(inventoryCache, "inventoryCache cannot be null");
        this.delegate = Enforce.notNull(delegate, "delegate cannot be null");
    }

    @Override
    protected void doInitialize(OcflExtensionConfig layoutConfig) {
        this.delegate.initializeStorage(this.ocflVersion, layoutConfig, this.inventoryMapper, this.supportEvaluator);
    }

    @Override
    public Inventory loadInventory(String objectId) {
        this.ensureOpen();
        return this.inventoryCache.get(objectId, this.delegate::loadInventory);
    }

    @Override
    public void storeNewVersion(Inventory inventory, Path stagingDir) {
        this.ensureOpen();
        try {
            this.delegate.storeNewVersion(inventory, stagingDir);
            this.inventoryCache.put(inventory.getId(), inventory);
        }
        catch (ObjectOutOfSyncException e2) {
            this.inventoryCache.invalidate(inventory.getId());
            throw e2;
        }
    }

    @Override
    public Map<String, OcflFileRetriever> getObjectStreams(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        return this.delegate.getObjectStreams(inventory, versionNum);
    }

    @Override
    public void reconstructObjectVersion(Inventory inventory, VersionNum versionNum, Path stagingDir) {
        this.ensureOpen();
        this.delegate.reconstructObjectVersion(inventory, versionNum, stagingDir);
    }

    @Override
    public void purgeObject(String objectId) {
        this.ensureOpen();
        try {
            this.delegate.purgeObject(objectId);
        }
        finally {
            this.inventoryCache.invalidate(objectId);
        }
    }

    @Override
    public void commitMutableHead(Inventory oldInventory, Inventory newInventory, Path stagingDir) {
        this.ensureOpen();
        try {
            this.delegate.commitMutableHead(oldInventory, newInventory, stagingDir);
            this.inventoryCache.put(newInventory.getId(), newInventory);
        }
        catch (ObjectOutOfSyncException e2) {
            this.inventoryCache.invalidate(newInventory.getId());
            throw e2;
        }
    }

    @Override
    public void purgeMutableHead(String objectId) {
        this.ensureOpen();
        try {
            this.delegate.purgeMutableHead(objectId);
        }
        finally {
            this.inventoryCache.invalidate(objectId);
        }
    }

    @Override
    public void rollbackToVersion(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        try {
            this.delegate.rollbackToVersion(inventory, versionNum);
        }
        finally {
            this.inventoryCache.invalidate(inventory.getId());
        }
    }

    @Override
    public boolean containsObject(String objectId) {
        this.ensureOpen();
        if (this.inventoryCache.contains(objectId)) {
            return true;
        }
        return this.delegate.containsObject(objectId);
    }

    @Override
    public String objectRootPath(String objectId) {
        this.ensureOpen();
        return this.delegate.objectRootPath(objectId);
    }

    @Override
    public Stream<String> listObjectIds() {
        this.ensureOpen();
        return this.delegate.listObjectIds();
    }

    @Override
    public void exportVersion(ObjectVersionId objectVersionId, Path outputPath) {
        this.ensureOpen();
        this.delegate.exportVersion(objectVersionId, outputPath);
    }

    @Override
    public void exportObject(String objectId, Path outputPath) {
        this.ensureOpen();
        this.delegate.exportObject(objectId, outputPath);
    }

    @Override
    public void importObject(String objectId, Path objectPath) {
        this.ensureOpen();
        this.delegate.importObject(objectId, objectPath);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

