/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.CharStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.InputStreamBuffered;

public final class InStreamASCII
extends Reader
implements CharStream {
    private InputStreamBuffered input;
    private long count = 0L;

    public InStreamASCII(InputStream in) {
        if (in instanceof InputStreamBuffered) {
            this.input = (InputStreamBuffered)in;
            return;
        }
        this.input = new InputStreamBuffered(in);
    }

    public InStreamASCII(InputStreamBuffered in) {
        this.input = in;
    }

    @Override
    public boolean ready() throws IOException {
        return this.input.available() > 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void closeStream() {
        IO.close(this.input);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i2 = off; i2 < off + len; ++i2) {
            int x = this.read();
            if (x == -1) {
                if (i2 == off) {
                    return -1;
                }
                return i2 - off;
            }
            if (x > 128) {
                throw new AtlasException("Illegal ASCII character : " + x);
            }
            cbuf[i2] = (char)x;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        return this.advance();
    }

    @Override
    public int advance() {
        ++this.count;
        return this.input.advance();
    }
}

