/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferLib {
    public static boolean allowArray = true;

    private ByteBufferLib() {
    }

    public static void fill(ByteBuffer bb, byte v) {
        ByteBufferLib.fill(bb, bb.position(), bb.limit(), v);
    }

    public static void fill(ByteBuffer bb, int start, int finish, byte v) {
        for (int i2 = start; i2 < finish; ++i2) {
            bb.put(i2, v);
        }
    }

    public static String details(ByteBuffer byteBuffer) {
        return "[pos=" + byteBuffer.position() + " lim=" + byteBuffer.limit() + " cap=" + byteBuffer.capacity() + "]";
    }

    public static void print(ByteBuffer byteBuffer) {
        ByteBufferLib.print(System.out, byteBuffer);
    }

    public static void print(PrintStream out, ByteBuffer byteBuffer) {
        int i2;
        byteBuffer = byteBuffer.duplicate();
        out.printf("ByteBuffer[pos=%d lim=%d cap=%d]", byteBuffer.position(), byteBuffer.limit(), byteBuffer.capacity());
        int maxBytes = 60;
        for (i2 = 0; i2 < maxBytes && i2 < byteBuffer.limit(); ++i2) {
            if (i2 % 20 == 0) {
                out.println();
            }
            out.printf(" 0x%02X", byteBuffer.get(i2));
        }
        if (i2 < byteBuffer.limit()) {
            if (i2 % 24 == 0) {
                out.println();
            }
            out.print(" ...");
        }
        out.println();
    }

    public static boolean sameValue(ByteBuffer bb1, ByteBuffer bb2) {
        if (bb1.capacity() != bb2.capacity()) {
            return false;
        }
        for (int i2 = 0; i2 < bb1.capacity(); ++i2) {
            if (bb1.get(i2) == bb2.get(i2)) continue;
            return false;
        }
        return true;
    }

    public static final ByteBuffer duplicate(ByteBuffer bb) {
        ByteBuffer bb2 = ByteBuffer.allocate(bb.limit() - bb.position());
        int x = bb.position();
        bb2.put(bb);
        bb.position(x);
        bb2.position(0);
        bb2.limit(bb2.capacity());
        return bb2;
    }

    public static final byte[] bb2array(ByteBuffer bb, int start, int finish) {
        byte[] b = new byte[finish - start];
        ByteBufferLib.bb2array(bb, start, finish, b);
        return b;
    }

    private static void bb2array(ByteBuffer bb, int start, int finish, byte[] b) {
        int j = 0;
        for (int i2 = start; i2 < finish; ++i2) {
            b[j] = bb.get(i2);
        }
    }

    public static final void bbcopy(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        if (src == dst) {
            return;
        }
        if (allowArray && bb.hasArray()) {
            ByteBufferLib.acopyArray(bb, src, dst, length, slotLen);
            return;
        }
        if (src < dst) {
            ByteBufferLib.bbcopy1(bb, src, dst, length, slotLen);
        } else {
            ByteBufferLib.bbcopy2(bb, src, dst, length, slotLen);
        }
    }

    private static final void bbcopy1(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        int bDst = dst * slotLen;
        int bSrc = src * slotLen;
        int bLen = length * slotLen;
        for (int i2 = bLen - 1; i2 >= 0; --i2) {
            bb.put(bDst + i2, bb.get(bSrc + i2));
        }
    }

    private static final void bbcopy2(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        int bDst = dst * slotLen;
        int bSrc = src * slotLen;
        int bLen = length * slotLen;
        for (int i2 = 0; i2 < bLen; ++i2) {
            bb.put(bDst + i2, bb.get(bSrc + i2));
        }
    }

    public static final void bbcopy(ByteBuffer bb1, int src, ByteBuffer bb2, int dst, int length, int slotLen) {
        if (allowArray && bb1.hasArray() && bb2.hasArray()) {
            ByteBufferLib.acopyArray(bb1, src, bb2, dst, length, slotLen);
            return;
        }
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        for (int i2 = 0; i2 < bLen; ++i2) {
            bb2.put(bDst + i2, bb1.get(bSrc + i2));
        }
    }

    public static final void bbfill(ByteBuffer bb, int fromIdx, int toIdx, byte fillValue, int slotLen) {
        if (allowArray && bb.hasArray()) {
            ByteBufferLib.afillArray(bb, fromIdx, toIdx, fillValue, slotLen);
            return;
        }
        int bStart = fromIdx * slotLen;
        int bFinish = toIdx * slotLen;
        for (int i2 = bStart; i2 < bFinish; ++i2) {
            bb.put(i2, fillValue);
        }
    }

    private static final void acopyArray(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        byte[] b = bb.array();
        int offset = bb.arrayOffset();
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        System.arraycopy(b, offset + bSrc, b, offset + bDst, bLen);
    }

    private static final void acopyArray(ByteBuffer bb1, int src, ByteBuffer bb2, int dst, int length, int slotLen) {
        byte[] b1 = bb1.array();
        byte[] b2 = bb2.array();
        int offset1 = bb1.arrayOffset();
        int offset2 = bb2.arrayOffset();
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        System.arraycopy(b1, offset1 + bSrc, b2, offset2 + bDst, bLen);
    }

    private static final void afillArray(ByteBuffer bb, int fromIdx, int toIdx, byte fillValue, int slotLen) {
        int offset = bb.arrayOffset();
        int bStart = fromIdx * slotLen;
        int bFinish = toIdx * slotLen;
        Arrays.fill(bb.array(), bStart + offset, bFinish + offset, fillValue);
    }
}

