/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.WebLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaType {
    private static Logger log = LoggerFactory.getLogger(MediaType.class);
    private static final String strCharset = "charset";
    private final String type;
    private final String subType;
    private final Map<String, String> params;
    private String strContentType = null;

    protected MediaType(ParsedMediaType parser) {
        this.type = parser.type;
        this.subType = parser.subType;
        this.params = parser.params;
    }

    public MediaType(MediaType other) {
        this.type = other.type;
        this.subType = other.subType;
        this.params = new LinkedHashMap<String, String>(other.params);
    }

    public MediaType(String type, String subType) {
        this(type, subType, null);
    }

    public MediaType(String type, String subType, String charset) {
        this.type = type;
        this.subType = subType;
        this.params = new LinkedHashMap<String, String>();
        if (charset != null) {
            this.setParameter(strCharset, charset);
        }
    }

    public static MediaType create(String contentType, String charset) {
        ParsedMediaType mediaType = MediaType.parse(contentType);
        if (charset != null) {
            mediaType.params.put(strCharset, charset);
        }
        return new MediaType(mediaType);
    }

    public static MediaType createFromContentType(String string) {
        return new MediaType(MediaType.parse(string));
    }

    public static MediaType create(String contentType, String subType, String charset) {
        return new MediaType(contentType, subType, charset);
    }

    public static MediaType create(String string) {
        if (string == null) {
            return null;
        }
        return new MediaType(MediaType.parse(string));
    }

    public static ParsedMediaType parse(String string) {
        ParsedMediaType mt = new ParsedMediaType();
        String[] x = WebLib.split(string, ";");
        String[] t = WebLib.split(x[0], "/");
        mt.type = t[0];
        if (t.length > 1) {
            mt.subType = t[1];
        }
        for (int i2 = 1; i2 < x.length; ++i2) {
            String[] z = WebLib.split(x[i2], "=");
            if (z.length == 2) {
                mt.params.put(z[0], z[1]);
                continue;
            }
            log.warn("Duff parameter: " + x[i2] + " in " + string);
        }
        return mt;
    }

    public String toHeaderString() {
        StringBuilder b = new StringBuilder();
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            b.append(";");
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (String k : this.params.keySet()) {
            if (k.equals("boundary")) continue;
            String v = this.params.get(k);
            b.append(" ");
            b.append(k);
            b.append("=");
            b.append(v);
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        return Lib.hashCodeObject(this.type, 1) ^ Lib.hashCodeObject(this.subType, 2) ^ Lib.hashCodeObject(this.params, 3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaType mt = (MediaType)object;
        return Lib.equal(this.type, mt.type) && Lib.equal(this.subType, mt.subType) && Lib.equal(this.params, mt.params);
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    private void setParameter(String name, String value) {
        this.params.put(name, value);
        this.strContentType = null;
    }

    public String getContentType() {
        if (this.strContentType != null) {
            return this.strContentType;
        }
        if (this.subType == null) {
            return this.type;
        }
        return this.type + "/" + this.subType;
    }

    public String getCharset() {
        return this.getParameter(strCharset);
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    static class ParsedMediaType {
        public String type;
        public String subType;
        public Map<String, String> params = new LinkedHashMap<String, String>();

        ParsedMediaType() {
        }
    }
}

