/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.util.DateTimeStruct;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.jena.riot.process.normalize.DatatypeHandler;

class NormalizeValue {
    static DatatypeHandler dtBoolean = new DatatypeHandler(){

        @Override
        public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
            if (lexicalForm.equals("1")) {
                return NodeConst.nodeTrue;
            }
            if (lexicalForm.equals("0")) {
                return NodeConst.nodeFalse;
            }
            return node;
        }
    };
    static DatatypeHandler dtAnyDateTime;
    static DatatypeHandler dtDateTime;
    static DatatypeHandler dtInteger;
    static DatatypeHandler dtDecimal;
    private static DecimalFormatSymbols decimalNumberSymbols;
    private static NumberFormat fmtFloatingPoint;
    static DatatypeHandler dtDouble;
    static DatatypeHandler dtFloat;
    static DatatypeHandler dtXSDString;
    static DatatypeHandler dtSimpleLiteral;
    static DatatypeHandler dtPlainLiteral;

    NormalizeValue() {
    }

    static {
        dtDateTime = dtAnyDateTime = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                int i2;
                if (lexicalForm.indexOf(46) < 0) {
                    return node;
                }
                DateTimeStruct dts = DateTimeStruct.parseDateTime(lexicalForm);
                int idx = dts.second.indexOf(46);
                for (i2 = dts.second.length() - 1; i2 > idx && dts.second.charAt(i2) == '0'; --i2) {
                }
                if (i2 == dts.second.length()) {
                    return node;
                }
                dts.second = i2 == idx ? dts.second.substring(0, idx) : dts.second.substring(0, i2 + 1);
                String lex2 = dts.toString();
                return NodeFactory.createLiteral(lex2, null, datatype);
            }
        };
        dtInteger = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                char[] chars = lexicalForm.toCharArray();
                if (chars.length == 0) {
                    return node;
                }
                String lex2 = lexicalForm;
                if (lex2.startsWith("+")) {
                    lex2 = lex2.substring(1);
                }
                if (lex2.length() > 8) {
                    lex2 = new BigInteger(lexicalForm).toString();
                } else {
                    int x = Integer.parseInt(lex2);
                    lex2 = Integer.toString(x);
                }
                if (datatype.equals(XSDDatatype.XSDinteger) && lex2.equals(lexicalForm)) {
                    return node;
                }
                return NodeFactory.createLiteral(lex2, null, XSDDatatype.XSDinteger);
            }
        };
        dtDecimal = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                BigDecimal bd = new BigDecimal(lexicalForm).stripTrailingZeros();
                String lex2 = bd.toPlainString();
                if (lex2.indexOf(46) == -1) {
                    lex2 = lex2 + ".0";
                }
                if (lex2.equals(lexicalForm)) {
                    return node;
                }
                return NodeFactory.createLiteral(lex2, null, datatype);
            }
        };
        decimalNumberSymbols = new DecimalFormatSymbols(Locale.ROOT);
        fmtFloatingPoint = new DecimalFormat("0.0#################E0", decimalNumberSymbols);
        dtDouble = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                double d = Double.parseDouble(lexicalForm);
                String lex2 = fmtFloatingPoint.format(d);
                if (lex2.equals(lexicalForm)) {
                    return node;
                }
                return NodeFactory.createLiteral(lex2, null, datatype);
            }
        };
        dtFloat = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                float f = Float.parseFloat(lexicalForm);
                String lex2 = fmtFloatingPoint.format(f);
                if (lex2.equals(lexicalForm)) {
                    return node;
                }
                return NodeFactory.createLiteral(lex2, null, datatype);
            }
        };
        dtXSDString = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                return NodeFactory.createLiteral(lexicalForm);
            }
        };
        dtSimpleLiteral = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                return NodeFactory.createLiteral(lexicalForm, "", datatype);
            }
        };
        dtPlainLiteral = new DatatypeHandler(){

            @Override
            public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
                int idx = lexicalForm.lastIndexOf(64);
                if (idx == -1) {
                    return node;
                }
                String lex = lexicalForm.substring(0, idx);
                if (idx == lexicalForm.length() - 1) {
                    return NodeFactory.createLiteral(lex);
                }
                String lang = lexicalForm.substring(idx + 1);
                return NodeFactory.createLiteral(lex, lang, null);
            }
        };
    }
}

