/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ga;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class IrishLowerCaseFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public IrishLowerCaseFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int i2;
            char[] chArray = this.termAtt.buffer();
            int chLen = this.termAtt.length();
            int idx = 0;
            if (chLen > 1 && (chArray[0] == 'n' || chArray[0] == 't') && this.isUpperVowel(chArray[1])) {
                chArray = this.termAtt.resizeBuffer(chLen + 1);
                for (i2 = chLen; i2 > 1; --i2) {
                    chArray[i2] = chArray[i2 - 1];
                }
                chArray[1] = 45;
                this.termAtt.setLength(chLen + 1);
                idx = 2;
                ++chLen;
            }
            for (i2 = idx; i2 < chLen; i2 += Character.toChars(Character.toLowerCase(chArray[i2]), chArray, i2)) {
            }
            return true;
        }
        return false;
    }

    private boolean isUpperVowel(int v) {
        switch (v) {
            case 65: 
            case 69: 
            case 73: 
            case 79: 
            case 85: 
            case 193: 
            case 201: 
            case 205: 
            case 211: 
            case 218: {
                return true;
            }
        }
        return false;
    }
}

