/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.util.ArrayUtil;

public final class DelimitedTermFrequencyTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TermFrequencyAttribute tfAtt = this.addAttribute(TermFrequencyAttribute.class);

    public DelimitedTermFrequencyTokenFilter(TokenStream input) {
        this(input, '|');
    }

    public DelimitedTermFrequencyTokenFilter(TokenStream input, char delimiter) {
        super(input);
        this.delimiter = delimiter;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i2 = 0; i2 < length; ++i2) {
                if (buffer[i2] != this.delimiter) continue;
                this.termAtt.setLength(i2);
                this.tfAtt.setTermFrequency(ArrayUtil.parseInt(buffer, ++i2, length - i2));
                return true;
            }
            return true;
        }
        return false;
    }
}

