/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class NGramPhraseQuery
extends Query {
    private final int n;
    private final PhraseQuery phraseQuery;

    public NGramPhraseQuery(int n, PhraseQuery query2) {
        this.n = n;
        this.phraseQuery = Objects.requireNonNull(query2);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        boolean isOptimizable;
        Term[] terms = this.phraseQuery.getTerms();
        int[] positions = this.phraseQuery.getPositions();
        boolean bl = isOptimizable = this.phraseQuery.getSlop() == 0 && this.n >= 2 && terms.length >= 3;
        if (isOptimizable) {
            for (int i2 = 1; i2 < positions.length; ++i2) {
                if (positions[i2] == positions[i2 - 1] + 1) continue;
                isOptimizable = false;
                break;
            }
        }
        if (!isOptimizable) {
            return this.phraseQuery.rewrite(reader);
        }
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        for (int i3 = 0; i3 < terms.length; ++i3) {
            if (i3 % this.n != 0 && i3 != terms.length - 1) continue;
            builder.add(terms[i3], i3);
        }
        return builder.build();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((NGramPhraseQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(NGramPhraseQuery other) {
        return this.n == other.n && this.phraseQuery.equals(other.phraseQuery);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.phraseQuery.hashCode();
        h2 = 31 * h2 + this.n;
        return h2;
    }

    public int getN() {
        return this.n;
    }

    public Term[] getTerms() {
        return this.phraseQuery.getTerms();
    }

    public int[] getPositions() {
        return this.phraseQuery.getPositions();
    }

    @Override
    public String toString(String field) {
        return this.phraseQuery.toString(field);
    }
}

