/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;

public abstract class PriorityQueue<T>
implements Iterable<T> {
    private int size = 0;
    private final int maxSize;
    private final T[] heap;

    public PriorityQueue(int maxSize) {
        this(maxSize, true);
    }

    public PriorityQueue(int maxSize, boolean prepopulate) {
        T sentinel;
        int heapSize;
        if (0 == maxSize) {
            heapSize = 2;
        } else {
            heapSize = maxSize + 1;
            if (heapSize > ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be <= " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + maxSize);
            }
        }
        Object[] h2 = new Object[heapSize];
        this.heap = h2;
        this.maxSize = maxSize;
        if (prepopulate && (sentinel = this.getSentinelObject()) != null) {
            this.heap[1] = sentinel;
            for (int i2 = 2; i2 < this.heap.length; ++i2) {
                this.heap[i2] = this.getSentinelObject();
            }
            this.size = maxSize;
        }
    }

    protected abstract boolean lessThan(T var1, T var2);

    protected T getSentinelObject() {
        return null;
    }

    public final T add(T element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public T insertWithOverflow(T element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return null;
        }
        if (this.size > 0 && !this.lessThan(element, this.heap[1])) {
            T ret = this.heap[1];
            this.heap[1] = element;
            this.updateTop();
            return ret;
        }
        return element;
    }

    public final T top() {
        return this.heap[1];
    }

    public final T pop() {
        if (this.size > 0) {
            T result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap(1);
            return result;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap(1);
        return this.heap[1];
    }

    public final T updateTop(T newTop) {
        this.heap[1] = newTop;
        return this.updateTop();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i2 = 0; i2 <= this.size; ++i2) {
            this.heap[i2] = null;
        }
        this.size = 0;
    }

    public final boolean remove(T element) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.heap[i2] != element) continue;
            this.heap[i2] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            if (i2 <= this.size && !this.upHeap(i2)) {
                this.downHeap(i2);
            }
            return true;
        }
        return false;
    }

    private final boolean upHeap(int origPos) {
        int i2 = origPos;
        T node = this.heap[i2];
        for (int j = i2 >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i2] = this.heap[j];
            i2 = j;
        }
        this.heap[i2] = node;
        return i2 != origPos;
    }

    private final void downHeap(int i2) {
        T node = this.heap[i2];
        int j = i2 << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i2] = this.heap[j];
            i2 = j;
            k = (j = i2 << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i2] = node;
    }

    protected final Object[] getHeapArray() {
        return this.heap;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 1;

            @Override
            public boolean hasNext() {
                return this.i <= PriorityQueue.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PriorityQueue.this.heap[this.i++];
            }
        };
    }
}

