/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.Sorter;

abstract class StringMSBRadixSorter
extends MSBRadixSorter {
    StringMSBRadixSorter() {
        super(Integer.MAX_VALUE);
    }

    protected abstract BytesRef get(int var1);

    @Override
    protected int byteAt(int i2, int k) {
        BytesRef ref = this.get(i2);
        if (ref.length <= k) {
            return -1;
        }
        return ref.bytes[ref.offset + k] & 0xFF;
    }

    @Override
    protected Sorter getFallbackSorter(final int k) {
        return new IntroSorter(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            private void get(int i2, int k2, BytesRef scratch) {
                BytesRef ref = StringMSBRadixSorter.this.get(i2);
                assert (ref.length >= k2);
                scratch.bytes = ref.bytes;
                scratch.offset = ref.offset + k2;
                scratch.length = ref.length - k2;
            }

            @Override
            protected void swap(int i2, int j) {
                StringMSBRadixSorter.this.swap(i2, j);
            }

            @Override
            protected int compare(int i2, int j) {
                this.get(i2, k, this.scratch1);
                this.get(j, k, this.scratch2);
                return this.scratch1.compareTo(this.scratch2);
            }

            @Override
            protected void setPivot(int i2) {
                this.get(i2, k, this.pivot);
            }

            @Override
            protected int comparePivot(int j) {
                this.get(j, k, this.scratch2);
                return this.pivot.compareTo(this.scratch2);
            }
        };
    }
}

