/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;

class DocIdsWriter {
    private DocIdsWriter() {
    }

    static void writeDocIds(int[] docIds, int start, int count, DataOutput out) throws IOException {
        boolean sorted = true;
        for (int i2 = 1; i2 < count; ++i2) {
            if (docIds[start + i2 - 1] <= docIds[start + i2]) continue;
            sorted = false;
            break;
        }
        if (sorted) {
            out.writeByte((byte)0);
            int previous = 0;
            for (int i3 = 0; i3 < count; ++i3) {
                int doc = docIds[start + i3];
                out.writeVInt(doc - previous);
                previous = doc;
            }
        } else {
            int i4;
            long max2 = 0L;
            for (i4 = 0; i4 < count; ++i4) {
                max2 |= Integer.toUnsignedLong(docIds[start + i4]);
            }
            if (max2 <= 0xFFFFFFL) {
                out.writeByte((byte)24);
                for (i4 = 0; i4 < count; ++i4) {
                    out.writeShort((short)(docIds[start + i4] >>> 8));
                    out.writeByte((byte)docIds[start + i4]);
                }
            } else {
                out.writeByte((byte)32);
                for (i4 = 0; i4 < count; ++i4) {
                    out.writeInt(docIds[start + i4]);
                }
            }
        }
    }

    static void readInts(IndexInput in, int count, int[] docIDs) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                DocIdsWriter.readDeltaVInts(in, count, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, docIDs);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readDeltaVInts(IndexInput in, int count, int[] docIDs) throws IOException {
        int doc = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            docIDs[i2] = doc += in.readVInt();
        }
    }

    static <T> void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
        for (int i2 = 0; i2 < count; ++i2) {
            docIDs[i2] = in.readInt();
        }
    }

    private static void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int i2;
        for (i2 = 0; i2 < count - 7; i2 += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            docIDs[i2] = (int)(l1 >>> 40);
            docIDs[i2 + 1] = (int)(l1 >>> 16) & 0xFFFFFF;
            docIDs[i2 + 2] = (int)((l1 & 0xFFFFL) << 8 | l2 >>> 56);
            docIDs[i2 + 3] = (int)(l2 >>> 32) & 0xFFFFFF;
            docIDs[i2 + 4] = (int)(l2 >>> 8) & 0xFFFFFF;
            docIDs[i2 + 5] = (int)((l2 & 0xFFL) << 16 | l3 >>> 48);
            docIDs[i2 + 6] = (int)(l3 >>> 24) & 0xFFFFFF;
            docIDs[i2 + 7] = (int)l3 & 0xFFFFFF;
        }
        while (i2 < count) {
            docIDs[i2] = Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte());
            ++i2;
        }
    }

    static void readInts(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                DocIdsWriter.readDeltaVInts(in, count, visitor);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, visitor);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count, visitor);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readDeltaVInts(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int doc = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            visitor.visit(doc += in.readVInt());
        }
    }

    static void readInts32(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        for (int i2 = 0; i2 < count; ++i2) {
            visitor.visit(in.readInt());
        }
    }

    private static void readInts24(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int i2;
        for (i2 = 0; i2 < count - 7; i2 += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            visitor.visit((int)(l1 >>> 40));
            visitor.visit((int)(l1 >>> 16) & 0xFFFFFF);
            visitor.visit((int)((l1 & 0xFFFFL) << 8 | l2 >>> 56));
            visitor.visit((int)(l2 >>> 32) & 0xFFFFFF);
            visitor.visit((int)(l2 >>> 8) & 0xFFFFFF);
            visitor.visit((int)((l2 & 0xFFL) << 16 | l3 >>> 48));
            visitor.visit((int)(l3 >>> 24) & 0xFFFFFF);
            visitor.visit((int)l3 & 0xFFFFFF);
        }
        while (i2 < count) {
            visitor.visit(Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte()));
            ++i2;
        }
    }
}

