/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.core.OcflRepositoryBuilder;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedNTupleLayoutConfig;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMappers;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorage;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.handlers.ocfl.PlainOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.cache.NoOpCache;
import org.springframework.beans.factory.FactoryBean;

public class OcflSessionFactoryFactoryBean
implements FactoryBean<OcflObjectSessionFactory> {
    private final Path ocflRoot;
    private final Path stagingDir;
    private final MigrationType migrationType;
    private final String user;
    private final String userUri;
    private final DigestAlgorithm digestAlgorithm;

    public OcflSessionFactoryFactoryBean(Path ocflRoot, Path stagingDir, MigrationType migrationType, String user, String userUri, DigestAlgorithm digestAlgorithm) {
        this.ocflRoot = ocflRoot;
        this.stagingDir = stagingDir;
        this.migrationType = migrationType;
        this.user = user;
        this.userUri = userUri;
        this.digestAlgorithm = digestAlgorithm;
    }

    public OcflSessionFactoryFactoryBean(Path ocflRoot, Path stagingDir, MigrationType migrationType, String user, String userUri) {
        this(ocflRoot, stagingDir, migrationType, user, userUri, DigestAlgorithm.sha512);
    }

    @Override
    public OcflObjectSessionFactory getObject() {
        LogicalPathMapper logicalPathMapper = SystemUtils.IS_OS_WINDOWS ? LogicalPathMappers.percentEncodingWindowsMapper() : LogicalPathMappers.percentEncodingLinuxMapper();
        OcflConfig config = new OcflConfig();
        config.setDefaultDigestAlgorithm(this.digestAlgorithm);
        MutableOcflRepository ocflRepo = new OcflRepositoryBuilder().defaultLayoutConfig(new HashedNTupleLayoutConfig()).logicalPathMapper(logicalPathMapper).storage(FileSystemOcflStorage.builder().repositoryRoot(this.ocflRoot).build()).workDir(this.stagingDir).ocflConfig(config).buildMutable();
        if (this.migrationType == MigrationType.FEDORA_OCFL) {
            ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule(new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return new DefaultOcflObjectSessionFactory(ocflRepo, this.stagingDir, objectMapper, new NoOpCache<String, ResourceHeaders>(), CommitType.NEW_VERSION, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri);
        }
        return new PlainOcflObjectSessionFactory(ocflRepo, this.stagingDir, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri);
    }

    @Override
    public Class<?> getObjectType() {
        return OcflObjectSessionFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

