/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.foxml;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.foxml.FoxmlInputStreamFedoraObjectProcessor;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.fcrepo.migration.foxml.URLFetcher;

public class FoxmlDirectoryDFSIterator
implements Iterator<FedoraObjectProcessor> {
    private List<File> current;
    private Stack<List<File>> stack = new Stack();
    private InternalIDResolver resolver;
    private URLFetcher fetcher;
    private String localFedoraServer;
    private FileFilter fileFilter;

    public FoxmlDirectoryDFSIterator(File root, URLFetcher fetcher, String localFedoraServer, FileFilter fileFilter) {
        this.current = new ArrayList<File>(Arrays.asList(root.listFiles()));
        this.fetcher = fetcher;
        this.localFedoraServer = localFedoraServer;
        this.fileFilter = fileFilter;
    }

    public FoxmlDirectoryDFSIterator(File root, InternalIDResolver resolver, URLFetcher fetcher, String localFedoraServer, FileFilter fileFilter) {
        this(root, fetcher, localFedoraServer, fileFilter);
        this.resolver = resolver;
    }

    private boolean advanceToNext() {
        while (this.current.size() > 0 || this.stack.size() > 0) {
            if (this.current.isEmpty()) {
                this.current = this.stack.pop();
                continue;
            }
            File first = this.current.get(0);
            if (first.isFile()) {
                if (this.fileFilter.accept(first)) {
                    return true;
                }
                this.current.remove(0);
                return this.advanceToNext();
            }
            File directory = this.current.remove(0);
            this.stack.push(this.current);
            this.current = new ArrayList<File>(Arrays.asList(directory.listFiles()));
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.advanceToNext();
    }

    @Override
    public FedoraObjectProcessor next() {
        if (!this.advanceToNext()) {
            throw new IllegalStateException();
        }
        File currentFile = this.current.remove(0);
        try {
            return new FoxmlInputStreamFedoraObjectProcessor(currentFile, this.fetcher, this.resolver, this.localFedoraServer);
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException(currentFile.getPath() + " doesn't appear to be an XML file." + (String)(e2.getMessage() != null ? "  (" + e2.getMessage() + ")" : ""));
        }
        catch (FileNotFoundException e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

