/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class PackageUtils {
    static final String DEFAULT_PACKAGE_NAME = "";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    private PackageUtils() {
    }

    public static void assertPackageNameIsValid(String packageName) {
        Preconditions.notNull(packageName, "package name must not be null");
        if (packageName.equals(DEFAULT_PACKAGE_NAME)) {
            return;
        }
        Preconditions.notBlank(packageName, "package name must not contain only whitespace");
        boolean allValid = Arrays.stream(DOT_PATTERN.split(packageName, -1)).allMatch(JavaNameUtils::isJavaName);
        Preconditions.condition(allValid, "invalid part(s) in package name: " + packageName);
    }

    public static Optional<String> getAttribute(Class<?> type, Function<Package, String> function) {
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notNull(function, "function must not be null");
        Package typePackage = type.getPackage();
        if (typePackage != null) {
            return Optional.ofNullable(function.apply(typePackage));
        }
        return Optional.empty();
    }

    public static Optional<String> getAttribute(Class<?> type, String name) {
        Optional<String> optional;
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notBlank(name, "name must not be blank");
        CodeSource codeSource = type.getProtectionDomain().getCodeSource();
        URL jarUrl = codeSource.getLocation();
        JarFile jarFile = new JarFile(new File(jarUrl.toURI()));
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            optional = Optional.ofNullable(mainAttributes.getValue(name));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }

    static class JavaNameUtils {
        private static final Set<String> RESTRICTED_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_", "abstract", "assert", "break", "case", "catch", "const", "continue", "default", "do", "else", "enum", "false", "final", "finally", "for", "goto", "if", "import", "instanceof", "native", "new", "null", "private", "protected", "public", "return", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "volatile", "while")));

        JavaNameUtils() {
        }

        static boolean isJavaName(String name) {
            return name != null && !name.isEmpty() && JavaNameUtils.isNotRestrictedKeyword(name) && JavaNameUtils.isJavaIdentifier(name);
        }

        private static boolean isNotRestrictedKeyword(String name) {
            return !RESTRICTED_KEYWORDS.contains(name);
        }

        private static boolean isJavaIdentifier(String name) {
            int charCount;
            int start = name.codePointAt(0);
            if (!Character.isJavaIdentifierStart(start)) {
                return false;
            }
            for (int i2 = charCount = Character.charCount(start); i2 < name.length(); i2 += charCount) {
                int codePoint = name.codePointAt(i2);
                if (Character.isJavaIdentifierPart(codePoint)) continue;
                return false;
            }
            return true;
        }
    }
}

