/*
 * Copyright 2015 DuraSpace, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fcrepo.migration.foxml;

import javax.xml.bind.annotation.XmlAttribute;

import org.fcrepo.migration.ObjectProperty;

/**
 * An ObjectProperty implementation that is annotated to allow
 * JAXB unmarshalling from a FOXML XML file or stream.
 * @author mdurbin
 */
public class FoxmlObjectProperty implements ObjectProperty {

    @XmlAttribute(name = "NAME")
    String name;

    @XmlAttribute(name = "VALUE")
    String value;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getValue() {
        return value;
    }
}
