/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImportManager {
    public static final ImportManager instance = new ImportManager();
    protected Map<String, Graph> cache = new HashMap<String, Graph>();

    public void clear() {
        this.cache.clear();
    }

    public Model withImports(Model model) {
        return this.withImports(FileManager.get(), model);
    }

    public Model withImports(FileManager fm, Model model) {
        return this.withImports(fm, model, new HashSet<String>());
    }

    private Model withImports(FileManager fm, Model model, Set<String> loading) {
        StmtIterator oit = model.listStatements(null, OWL.imports, (RDFNode)null);
        StmtIterator jit = model.listStatements(null, JA.imports, (RDFNode)null);
        if (oit.hasNext() || jit.hasNext()) {
            MultiUnion g2 = new MultiUnion(new Graph[]{model.getGraph()});
            this.addImportedGraphs(fm, loading, oit, g2);
            this.addImportedGraphs(fm, loading, jit, g2);
            return ModelFactory.createModelForGraph(g2);
        }
        return model;
    }

    private void addImportedGraphs(FileManager fm, Set<String> loading, StmtIterator oit, MultiUnion g2) {
        while (oit.hasNext()) {
            String path = this.getObjectURI(oit.nextStatement());
            if (!loading.add(path)) continue;
            g2.addGraph(this.graphFor(fm, loading, path));
        }
    }

    private String getObjectURI(Statement s2) {
        RDFNode ob = s2.getObject();
        if (ob.isLiteral()) {
            return AssemblerHelp.getString(s2);
        }
        if (ob.isAnon()) {
            throw new BadObjectException(s2);
        }
        return ((Resource)ob).getURI();
    }

    protected Graph graphFor(FileManager fm, Set<String> loading, String path) {
        Graph already = this.cache.get(path);
        if (already == null) {
            Graph result = this.withImports(fm, fm.loadModel(path), loading).getGraph();
            this.cache.put(path, result);
            return result;
        }
        return already;
    }
}

