/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDBaseNumericType
extends XSDDatatype {
    private static final BigInteger ten = new BigInteger("10");
    private static final int QUOT = 0;
    private static final int REM = 1;

    public XSDBaseNumericType(String typeName) {
        super(typeName);
    }

    public XSDBaseNumericType(String typeName, Class<?> javaClass) {
        super(typeName, javaClass);
    }

    @Override
    public boolean isValidLiteral(LiteralLabel lit) {
        if (this.isBaseTypeCompatible(lit)) {
            String lex = lit.getLexicalForm();
            if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals) {
                if (lex.trim().equals(lex)) {
                    return this.isValid(lit.getLexicalForm());
                }
                return false;
            }
            return this.isValid(lit.getLexicalForm());
        }
        return false;
    }

    @Override
    public boolean isValidValue(Object valueForm) {
        if (valueForm instanceof Number) {
            return this.isValid(valueForm.toString());
        }
        return false;
    }

    @Override
    public Object cannonicalise(Object value) {
        if (value instanceof BigInteger) {
            return this.cannonicalizeInteger((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return this.cannonicalizeDecimal((BigDecimal)value);
        }
        return XSDBaseNumericType.suitableInteger(((Number)value).longValue());
    }

    private Object cannonicalizeDecimal(BigDecimal value) {
        if (value.scale() > 0) {
            BigInteger[] quotRem;
            BigInteger i2 = value.unscaledValue();
            int limit = value.scale();
            int nshift = 0;
            for (nshift = 0; nshift < limit && (quotRem = i2.divideAndRemainder(ten))[1].intValue() == 0; ++nshift) {
                i2 = quotRem[0];
            }
            if (nshift > 0 && (value = new BigDecimal(i2, limit - nshift)).scale() <= 0) {
                return this.cannonicalizeInteger(value.toBigInteger());
            }
            return value;
        }
        return this.cannonicalizeInteger(value.toBigInteger());
    }

    private Object cannonicalizeInteger(BigInteger value) {
        if (value.bitLength() > 63) {
            return value;
        }
        return XSDBaseNumericType.suitableInteger(value.longValue());
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        this.checkWhitespace(lexicalForm);
        return super.parse(lexicalForm);
    }

    protected void checkWhitespace(String lexicalForm) {
        if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals && !lexicalForm.trim().equals(lexicalForm)) {
            throw new DatatypeFormatException(lexicalForm, this, "whitespace violation");
        }
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        if (value1.getDatatype() instanceof XSDBaseNumericType && value2.getDatatype() instanceof XSDBaseNumericType) {
            Number n1 = (Number)value1.getValue();
            Number n2 = (Number)value2.getValue();
            if (n1 instanceof BigDecimal && n2 instanceof BigDecimal) {
                return ((BigDecimal)n1).compareTo((BigDecimal)n2) == 0;
            }
            return n1.equals(n2);
        }
        return false;
    }
}

