/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Set;

public abstract class CompositionBase
extends GraphBase {
    public static <T> Filter<T> reject(ClosableIterator<? extends T> i2) {
        final Set<? extends T> suppress = IteratorCollection.iteratorToSet(i2);
        return new Filter<T>(){

            @Override
            public boolean accept(T o) {
                return !suppress.contains(o);
            }
        };
    }

    public static <T> ClosableIterator<T> butNot(ClosableIterator<T> a, ClosableIterator<? extends T> b) {
        return new FilterIterator<T>(CompositionBase.reject(b), a);
    }

    public static <T> ExtendedIterator<T> recording(final ClosableIterator<T> i2, final Set<T> seen) {
        return new NiceIterator<T>(){

            @Override
            public void remove() {
                i2.remove();
            }

            @Override
            public boolean hasNext() {
                return i2.hasNext();
            }

            @Override
            public T next() {
                Object x = i2.next();
                seen.add(x);
                return x;
            }

            @Override
            public void close() {
                i2.close();
            }
        };
    }

    public static ExtendedIterator<Triple> rejecting(ExtendedIterator<Triple> i2, final Set<Triple> seen) {
        Filter<Triple> seenFilter = new Filter<Triple>(){

            @Override
            public boolean accept(Triple x) {
                return seen.contains(x);
            }
        };
        return i2.filterDrop(seenFilter);
    }

    public static ExtendedIterator<Triple> rejecting(ExtendedIterator<Triple> i2, final Graph seen) {
        Filter<Triple> seenFilter = new Filter<Triple>(){

            @Override
            public boolean accept(Triple x) {
                return seen.contains(x);
            }
        };
        return i2.filterDrop(seenFilter);
    }

    public static <T> Filter<T> ifIn(ClosableIterator<T> i2) {
        final Set<T> allow = IteratorCollection.iteratorToSet(i2);
        return new Filter<T>(){

            @Override
            public boolean accept(T x) {
                return allow.contains(x);
            }
        };
    }

    public static Filter<Triple> ifIn(final Graph g2) {
        return new Filter<Triple>(){

            @Override
            public boolean accept(Triple x) {
                return g2.contains(x);
            }
        };
    }
}

