/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.List;
import java.util.Map;

public class PolyadicPrefixMappingImpl
extends PrefixMappingImpl
implements PrefixMapping {
    private Polyadic poly;
    private PrefixMapping pending = new PrefixMappingImpl();

    public PolyadicPrefixMappingImpl(Polyadic p) {
        this.poly = p;
    }

    @Override
    protected boolean equals(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    @Override
    protected boolean sameAs(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    private PrefixMapping getBaseMapping() {
        Graph base = this.poly.getBaseGraph();
        return base == null ? this.pending : base.getPrefixMapping();
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        this.getBaseMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> other) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefixes(other);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        PrefixMapping bm = this.getBaseMapping();
        String s2 = bm.getNsPrefixURI(prefix);
        if (s2 == null && prefix.length() > 0) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (Graph graph : graphs) {
                String ss = graph.getPrefixMapping().getNsPrefixURI(prefix);
                if (ss == null) continue;
                return ss;
            }
        }
        return s2;
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        Map<String, String> result = CollectionFactory.createHashedMap();
        List<Graph> graphs = this.poly.getSubGraphs();
        int i2 = graphs.size();
        while (i2 > 0) {
            result.putAll(graphs.get(--i2).getPrefixMapping().getNsPrefixMap());
        }
        result.remove("");
        result.putAll(this.getBaseMapping().getNsPrefixMap());
        return result;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String s2 = this.getBaseMapping().getNsURIPrefix(uri);
        if (s2 == null) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (Graph graph : graphs) {
                String ss = graph.getPrefixMapping().getNsURIPrefix(uri);
                if (ss == null || ss.length() <= 0) continue;
                return ss;
            }
        }
        return s2;
    }

    @Override
    public String expandPrefix(String prefixed) {
        String s2 = this.getBaseMapping().expandPrefix(prefixed);
        if (s2.equals(prefixed)) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (Graph graph : graphs) {
                String ss = graph.getPrefixMapping().expandPrefix(prefixed);
                if (ss.equals(prefixed)) continue;
                return ss;
            }
        }
        return s2;
    }

    @Override
    public String toString() {
        return "<polyadic prefix map>";
    }

    @Override
    public String shortForm(String uri) {
        String s2 = this.getBaseMapping().shortForm(uri);
        if (s2.equals(uri)) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (Graph graph : graphs) {
                String ss = graph.getPrefixMapping().shortForm(uri);
                if (ss.equals(uri)) continue;
                return ss;
            }
        }
        return s2;
    }

    @Override
    public String qnameFor(String uri) {
        String result = this.getBaseMapping().qnameFor(uri);
        if (result == null) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (Graph graph : graphs) {
                String ss = graph.getPrefixMapping().qnameFor(uri);
                if (ss == null) continue;
                return ss;
            }
        }
        return result;
    }
}

