/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GraphMatcher {
    private static Random random = new Random(0L);
    private static final boolean TRACE = false;
    private Graph m;
    private GraphMatcher other;
    private int myHashLevel = 0;
    private static final int MAX_HASH_DEPTH = 3;
    private Map<Integer, Bucket> table;
    private int state;
    private static final int REHASHING = 1;
    private static final int HASH_OK = 2;
    private static final int HASH_BAD = 4;
    private Set<AnonResource> unboundAnonResources = CollectionFactory.createHashedSet();
    private Set<AnonResource> boundAnonResources = CollectionFactory.createHashedSet();
    private boolean refinableHash;
    private static final int NOVARS = 0;
    private static final int SX = 1;
    private static final int PX = 4;
    private static final int OX = 16;
    private static final int SD = 2;
    private static final int PD = 8;
    private static final int OD = 32;
    private static final int SXPY = 5;
    private static final int SXOY = 17;
    private static final int PXOY = 20;
    private static final int SXPYOZ = 21;
    private static final int SXPX = 10;
    private static final int SXOX = 34;
    private static final int PXOX = 40;
    private static final int SXPXOY = 26;
    private static final int SXPYOX = 38;
    private static final int SXPYOY = 41;
    private static final int SXPXOX = 42;
    private static final int S = 3;
    private static final int P = 12;
    private static final int O = 48;
    private Map<Node, SomeResource> anonLookup = CollectionFactory.createHashedMap();
    private static int col = 0;
    private static boolean lastDir = false;

    public static boolean equals(Graph m1, Graph m22) {
        if (m1 == m22) {
            return true;
        }
        return GraphMatcher.match(m1, m22) != null;
    }

    public static int hashCode(Graph g2) {
        ExtendedIterator<Triple> ci = GraphUtil.findAll(g2);
        int hash = 0;
        GraphMatcher gm = new GraphMatcher(g2);
        while (ci.hasNext()) {
            Triple t = (Triple)ci.next();
            GraphMatcher graphMatcher = gm;
            graphMatcher.getClass();
            hash += graphMatcher.new AnonStatement(t).myHashCode(null);
        }
        return hash;
    }

    public static Node[][] match(Graph m1, Graph m22) {
        return new GraphMatcher(m1).match(new GraphMatcher(m22));
    }

    private GraphMatcher(Graph m1x) {
        this.m = m1x;
    }

    private Node[][] match(GraphMatcher oth) {
        this.other = oth;
        oth.other = this;
        this.in(4);
        if (this.m.getCapabilities().sizeAccurate() && this.m.size() < this.other.m.size()) {
            return null;
        }
        if (this.other.m.getCapabilities().sizeAccurate() && this.m.size() > this.other.m.size()) {
            return null;
        }
        int myPrep = this.prepare(this.other.m);
        if (myPrep == -1 || myPrep != this.other.prepare(this.m)) {
            return null;
        }
        if (this.bind()) {
            if (!this.unboundAnonResources.isEmpty()) {
                GraphMatcher.impossible();
            }
            Node[][] rslt = new Node[this.boundAnonResources.size()][];
            int ix = 0;
            for (AnonResource r : this.boundAnonResources) {
                rslt[ix++] = new Node[]{r.r, r.bound.r};
            }
            return rslt;
        }
        return null;
    }

    private boolean bind() {
        Set<AnonResource> locallyBound = this.obligBindings();
        if (locallyBound == null) {
            return false;
        }
        this.check(2);
        Bucket bkt = this.smallestBucket();
        if (bkt == null) {
            return true;
        }
        Bucket otherBkt = this.other.matchBucket(bkt);
        if (otherBkt != null) {
            AnonResource v = bkt.aMember();
            Iterator<AnonResource> candidates = otherBkt.members();
            while (candidates.hasNext()) {
                this.check(6);
                AnonResource otherV = candidates.next();
                GraphMatcher.trace(true, "Guess: ");
                if (!bkt.bind(v, otherBkt, otherV)) continue;
                if (this.bind()) {
                    return true;
                }
                v.unbind();
            }
        }
        this.unbindAll(locallyBound);
        return false;
    }

    private Set<AnonResource> obligBindings() {
        boolean newBinding;
        int hashLevel = 0;
        Set<AnonResource> rslt = CollectionFactory.createHashedSet();
        this.check(6);
        do {
            if (this.rehash(hashLevel) != this.other.rehash(hashLevel)) {
                this.unbindAll(rslt);
                return null;
            }
            this.refinableHash = false;
            newBinding = false;
            Iterator<Bucket> singles = this.scanBuckets();
            while (singles.hasNext()) {
                newBinding = true;
                Bucket bkt = singles.next();
                Bucket otherBkt = this.other.matchBucket(bkt);
                if (otherBkt == null) {
                    this.unbindAll(rslt);
                    return null;
                }
                AnonResource bindMe = bkt.aMember();
                if (!bkt.bind(otherBkt)) {
                    this.unbindAll(rslt);
                    return null;
                }
                rslt.add(bindMe);
            }
            if (newBinding) {
                hashLevel = 0;
                continue;
            }
            ++hashLevel;
        } while (hashLevel < 3 && (this.refinableHash || newBinding));
        return rslt;
    }

    private Iterator<Bucket> scanBuckets() {
        this.check(2);
        return new FilterIterator<Bucket>(new Filter<Bucket>(){

            @Override
            public boolean accept(Bucket o) {
                Bucket b = o;
                if (b.size() == 1) {
                    return true;
                }
                if (!GraphMatcher.this.refinableHash) {
                    Iterator<AnonResource> it = b.members();
                    while (it.hasNext()) {
                        if (it.next().friends.isEmpty()) continue;
                        GraphMatcher.this.refinableHash = true;
                        break;
                    }
                }
                return false;
            }
        }, this.table.values().iterator());
    }

    private void unbindAll(Set<AnonResource> s2) {
        for (AnonResource value : s2) {
            value.unbind();
        }
        this.in(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int prepare(Graph otherm) {
        block9: {
            ss = GraphUtil.findAll(this.m);
            this.myHashLevel = 0;
            hash = 0;
            while (true) {
                if (ss.hasNext()) {
                    s = (Triple)ss.next();
                    ass = new AnonStatement(s);
                    if (ass.pattern == 0) {
                        if (otherm.contains(s)) continue;
                        var6_7 = -1;
                        return var6_7;
                    }
                    hash += ass.myHashCode(ass.vars[0]);
                    break block9;
                }
                var4_5 = hash == -1 ? 1 : hash;
                return var4_5;
            }
            finally {
                ss.close();
            }
        }
        i = 0;
        while (true) {
            if (i < ass.vars.length) ** break;
            ** continue;
            ass.vars[i].occursIn.add(ass);
            for (j = i + 1; j < ass.vars.length; ++j) {
                ass.vars[i].friends.add(ass.vars[j]);
                ass.vars[j].friends.add(ass.vars[i]);
            }
            ++i;
        }
    }

    private Bucket smallestBucket() {
        this.check(2);
        Iterator<Bucket> bit = this.table.values().iterator();
        Bucket smallB = null;
        int smallest = Integer.MAX_VALUE;
        while (bit.hasNext()) {
            Bucket b = bit.next();
            int sz = b.size();
            if (sz >= smallest) continue;
            smallB = b;
            smallest = sz;
        }
        return smallB;
    }

    private Bucket matchBucket(Bucket key) {
        this.check(2);
        Integer hash = new Integer(key.aMember().myHash);
        Bucket rslt = this.table.get(hash);
        if (rslt != null && key.size() != rslt.size()) {
            return null;
        }
        return rslt;
    }

    private int rehash(int lvl) {
        return this.rehash0(lvl);
    }

    private int rehash0(int level) {
        this.in(1);
        this.table = CollectionFactory.createHashedMap();
        this.myHashLevel = level;
        for (AnonResource a : this.unboundAnonResources) {
            Integer hash = new Integer(a.myHashCode());
            Bucket bkt = this.table.get(hash);
            if (bkt == null) {
                bkt = new Bucket();
                this.table.put(hash, bkt);
            }
            bkt.add(a);
        }
        int rslt = 0;
        for (Map.Entry<Integer, Bucket> pair : this.table.entrySet()) {
            int hash = pair.getKey();
            Bucket bkt = pair.getValue();
            int sz = bkt.size();
            rslt += sz * 65537 ^ hash;
        }
        this.in(2);
        return rslt;
    }

    private static boolean legalPattern(int mask) {
        switch (mask) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    private static int varPosInPattern(int i2, int pattern) {
        switch (pattern) {
            case 0: {
                break;
            }
            case 1: {
                if (i2 != 0) break;
                return 1;
            }
            case 16: {
                if (i2 != 0) break;
                return 16;
            }
            case 4: {
                if (i2 != 0) break;
                return 4;
            }
            case 5: {
                switch (i2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 17: {
                switch (i2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 20: {
                switch (i2) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 21: {
                switch (i2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 16;
                    }
                }
                break;
            }
            case 10: {
                if (i2 != 0) break;
                return 10;
            }
            case 34: {
                if (i2 != 0) break;
                return 34;
            }
            case 40: {
                if (i2 != 0) break;
                return 40;
            }
            case 26: {
                switch (i2) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 38: {
                switch (i2) {
                    case 0: {
                        return 34;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 41: {
                switch (i2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 40;
                    }
                }
                break;
            }
            case 42: {
                if (i2 != 0) break;
                return 42;
            }
        }
        System.out.println("Bad: " + i2 + " " + pattern);
        GraphMatcher.impossible();
        return 0;
    }

    static void count(Map<SomeResource, int[]> bag2, SomeResource r, int pos) {
        if (r instanceof AnonResource) {
            int[] v = bag2.get(r);
            if (v == null) {
                v = new int[]{-1, -1, -1};
                bag2.put(r, v);
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                if (v[i2] != -1) continue;
                v[i2] = pos;
                return;
            }
        }
    }

    private SomeResource convert(Node n) {
        if (n.isBlank()) {
            SomeResource anon = this.anonLookup.get(n);
            if (anon == null) {
                anon = new AnonResource(n);
                this.anonLookup.put(n, anon);
            }
            return anon;
        }
        return new FixedResource(n);
    }

    private void check(int s2) {
        if ((this.state & s2) == 0) {
            GraphMatcher.impossible();
        }
    }

    private void in(int s2) {
        this.state = s2;
        this.other.state = s2;
    }

    private static void impossible() {
        throw new JenaException("Cannot happen!");
    }

    private static void trace(boolean dir, String s2) {
    }

    private static void traceNL() {
    }

    private class AnonResource
    implements SomeResource {
        AnonResource bound;
        Node r;
        Set<AnonStatement> occursIn = CollectionFactory.createHashedSet();
        int[] hash = new int[3];
        int boundHash;
        Set<AnonResource> friends = CollectionFactory.createHashedSet();
        int myHash;

        public String toString() {
            String rslt = this.r.toString();
            if (this.bound != null) {
                rslt = rslt + "[" + this.bound.r.toString() + "]";
            }
            return rslt;
        }

        AnonResource(Node r) {
            GraphMatcher.this.unboundAnonResources.add(this);
            this.r = r;
        }

        @Override
        public int myHashCodeFromStatement() {
            if (this.bound != null) {
                return this.boundHash;
            }
            if (GraphMatcher.this.myHashLevel == 0) {
                return -889275714;
            }
            GraphMatcher.this.check(3);
            return this.hash[GraphMatcher.this.myHashLevel - 1];
        }

        int myHashCode() {
            GraphMatcher.this.check(1);
            if (this.bound != null) {
                GraphMatcher.impossible();
            }
            this.myHash = 0;
            for (AnonStatement ass : this.occursIn) {
                this.myHash += ass.myHashCode(this);
            }
            this.hash[((GraphMatcher)GraphMatcher.this).myHashLevel] = this.myHash;
            return this.myHash;
        }

        void bind(AnonResource pair) {
            this.bound = pair;
            if (!GraphMatcher.this.unboundAnonResources.remove(this)) {
                GraphMatcher.impossible();
            }
            GraphMatcher.this.boundAnonResources.add(this);
            if (pair.bound == null) {
                GraphMatcher.trace(true, this.r.getBlankNodeId() + "=" + pair.r.getBlankNodeId() + ", ");
                pair.bind(this);
                this.bound.boundHash = this.boundHash = random.nextInt();
            }
            if (this.bound.bound != this) {
                GraphMatcher.impossible();
            }
        }

        void unbind() {
            AnonResource pair = this.bound;
            this.bound = null;
            if (!GraphMatcher.this.boundAnonResources.remove(this)) {
                GraphMatcher.impossible();
            }
            GraphMatcher.this.unboundAnonResources.add(this);
            if (pair.bound != null) {
                GraphMatcher.trace(false, this.r.getBlankNodeId() + "!=" + pair.r.getBlankNodeId() + ", ");
                if (pair.bound != this) {
                    GraphMatcher.impossible();
                }
                pair.unbind();
            }
            GraphMatcher.this.in(4);
        }

        boolean checkBinding(AnonResource pair) {
            Set<StatementWrapper> otherStatements;
            if (this.occursIn.size() != pair.occursIn.size()) {
                return false;
            }
            Set<StatementWrapper> ourStatements = this.wrapStatements();
            return ourStatements.removeAll(otherStatements = pair.wrapStatements()) && ourStatements.isEmpty();
        }

        private Set<StatementWrapper> wrapStatements() {
            if (GraphMatcher.this.state == 4) {
                GraphMatcher.this.myHashLevel = 0;
            }
            Set<StatementWrapper> statements = CollectionFactory.createHashedSet();
            for (AnonStatement anOccursIn : this.occursIn) {
                statements.add(this.wrapStatement(anOccursIn));
            }
            return statements;
        }

        @Override
        public boolean mightBeEqual(SomeResource r) {
            if (r != null && r instanceof AnonResource) {
                AnonResource a = (AnonResource)r;
                return a == this || this.bound == a || this.bound == null && a.bound == null;
            }
            return false;
        }

        StatementWrapper wrapStatement(AnonStatement s2) {
            return new StatementWrapper(s2);
        }

        private class StatementWrapper {
            int wrapHash;
            AnonStatement statement;

            public boolean equals(Object o) {
                if (o == null || !(o instanceof StatementWrapper)) {
                    return false;
                }
                StatementWrapper w = (StatementWrapper)o;
                return this.wrapHash == w.wrapHash && this.statement.contextualEquals(AnonResource.this, w.statement, w.asAnonR());
            }

            public int hashCode() {
                return this.wrapHash;
            }

            StatementWrapper(AnonStatement s2) {
                this.wrapHash = s2.myHashCode(AnonResource.this);
                this.statement = s2;
            }

            AnonResource asAnonR() {
                return AnonResource.this;
            }
        }
    }

    private class Bucket {
        Set<AnonResource> anonRes = CollectionFactory.createHashedSet();
        int[] hash = new int[3];

        private Bucket() {
        }

        boolean bind(Bucket singleton) {
            return this.bind(this.aMember(), singleton, singleton.aMember());
        }

        boolean bind(AnonResource mine, Bucket other, AnonResource binding) {
            if (mine.checkBinding(binding)) {
                mine.bind(binding);
                return true;
            }
            return false;
        }

        void add(AnonResource r) {
            this.anonRes.add(r);
        }

        AnonResource aMember() {
            return this.anonRes.iterator().next();
        }

        Iterator<AnonResource> members() {
            return this.anonRes.iterator();
        }

        int size() {
            return this.anonRes.size();
        }
    }

    private class AnonStatement {
        int varCount;
        AnonResource[] vars;
        SomeResource subj;
        SomeResource pred;
        SomeResource obj;
        int pattern;

        AnonStatement(Triple s2) {
            Map<SomeResource, int[]> bag2 = CollectionFactory.createHashedMap();
            this.pattern = 0;
            this.subj = GraphMatcher.this.convert(s2.getSubject());
            this.pred = GraphMatcher.this.convert(s2.getPredicate());
            this.obj = GraphMatcher.this.convert(s2.getObject());
            GraphMatcher.count(bag2, this.subj, 0);
            GraphMatcher.count(bag2, this.pred, 2);
            GraphMatcher.count(bag2, this.obj, 4);
            this.varCount = bag2.size();
            this.vars = new AnonResource[this.varCount];
            this.add(this.subj);
            this.add(this.pred);
            this.add(this.obj);
            for (int[] v : bag2.values()) {
                int last = 2;
                while (v[last] == -1) {
                    --last;
                }
                int p = last == 0 ? 1 : 2;
                for (int i2 = 0; i2 <= last; ++i2) {
                    this.pattern |= p << v[i2];
                }
            }
            if (!GraphMatcher.legalPattern(this.pattern)) {
                System.out.println("s: " + this.subj + " p: " + this.pred + " o: " + this.obj + " pattern: " + this.pattern);
                GraphMatcher.impossible();
            }
        }

        private void add(SomeResource r) {
            if (r instanceof AnonResource) {
                for (int i2 = 0; i2 < this.vars.length; ++i2) {
                    if (this.vars[i2] != null && this.vars[i2] != r) continue;
                    this.vars[i2] = (AnonResource)r;
                    return;
                }
                GraphMatcher.impossible();
            }
        }

        int varPos(AnonResource v) {
            if (v == null) {
                return 0;
            }
            for (int i2 = 0; i2 < this.vars.length; ++i2) {
                if (this.vars[i2] != v) continue;
                return GraphMatcher.varPosInPattern(i2, this.pattern);
            }
            GraphMatcher.impossible();
            return 0;
        }

        int myHashCode(AnonResource v) {
            int vX;
            int hash = vX = this.varPos(v);
            if ((vX & 3) == 0) {
                hash ^= this.subj.myHashCodeFromStatement() * 257;
            }
            if ((vX & 0xC) == 0) {
                hash ^= this.pred.myHashCodeFromStatement() * 63;
            }
            if ((vX & 0x30) == 0) {
                hash ^= this.obj.myHashCodeFromStatement() * 65;
            }
            return hash;
        }

        boolean contextualEquals(AnonResource v, AnonStatement sB, AnonResource vB) {
            int vX = this.varPos(v);
            if (vX != sB.varPos(vB)) {
                return false;
            }
            return !((vX & 3) == 0 && !this.subj.mightBeEqual(sB.subj) || (vX & 0xC) == 0 && !this.pred.mightBeEqual(sB.pred) || (vX & 0x30) == 0 && !this.obj.mightBeEqual(sB.obj));
        }
    }

    private static class FixedResource
    implements SomeResource {
        int hash;
        Node node;

        public String toString() {
            return "f" + this.hash;
        }

        @Override
        public int myHashCodeFromStatement() {
            return this.hash;
        }

        FixedResource(Node n) {
            this.hash = n.hashCode();
            this.node = n;
        }

        @Override
        public boolean mightBeEqual(SomeResource r) {
            if (r != null && r instanceof FixedResource) {
                FixedResource f = (FixedResource)r;
                return this.hash == f.hash && this.node.equals(f.node);
            }
            return false;
        }
    }

    private static interface SomeResource {
        public int myHashCodeFromStatement();

        public boolean mightBeEqual(SomeResource var1);
    }
}

