/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.io.Writer;

public class N3IndentedWriter {
    String lineSeparator = JenaRuntime.getLineSeparator();
    Writer writer;
    int column;
    int row;
    int currentIndent;

    public N3IndentedWriter(Writer w) {
        this.writer = w;
        this.column = 0;
        this.row = 0;
        this.currentIndent = 0;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void incIndent(int x) {
        this.currentIndent += x;
    }

    public void decIndent(int x) {
        this.currentIndent -= x;
    }

    public void setIndent(int x) {
        this.currentIndent = x;
    }

    public void print(String s2) {
        try {
            this.writer.write(s2);
            this.column += s2.length();
        }
        catch (IOException ex) {
            throw new JenaException(ex);
        }
    }

    public void println(String s2) {
        try {
            this.writer.write(s2);
            this.println();
        }
        catch (IOException ex) {
            throw new JenaException(ex);
        }
    }

    public void println() {
        try {
            this.writer.write(this.lineSeparator);
            this.writer.flush();
            this.column = 0;
            ++this.row;
            this.padTo();
        }
        catch (IOException ex) {
            throw new JenaException(ex);
        }
    }

    public void padTo() throws IOException {
        StringBuilder sBuff = new StringBuilder();
        for (int i2 = 0; i2 < this.currentIndent; ++i2) {
            this.writer.write(32);
        }
        this.column += this.currentIndent;
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException ioEx) {
            throw new JenaException(ioEx);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException ioEx) {
            throw new JenaException(ioEx);
        }
    }
}

