/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.UniqueFilter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.HashSet;

public class OntClassImpl
extends OntResourceImpl
implements OntClass {
    private static final String[] IGNORE_NAMESPACES = new String[]{"http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), "urn:x-hp-jena:rubrik/"};
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to OntClass: it does not have rdf:type owl:Class or equivalent");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, OntClass.class);
        }
    };

    public OntClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setSuperClass(Resource cls) {
        this.setPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    @Override
    public void addSuperClass(Resource cls) {
        this.addPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    @Override
    public OntClass getSuperClass() {
        return this.objectAs(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class);
    }

    @Override
    public ExtendedIterator<OntClass> listSuperClasses() {
        return this.listSuperClasses(false);
    }

    @Override
    public ExtendedIterator<OntClass> listSuperClasses(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), direct, false).filterDrop(new OntResourceImpl.SingleEqualityFilter<OntClassImpl>(this, this)).filterKeep(new UniqueFilter());
    }

    @Override
    public boolean hasSuperClass(Resource cls) {
        return this.hasSuperClass(cls, false);
    }

    @Override
    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    @Override
    public boolean hasSuperClass(Resource cls, boolean direct) {
        OntModel m3;
        if (!direct) {
            return this.hasPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
        }
        InfGraph ig = null;
        if (this.getGraph() instanceof InfGraph) {
            ig = (InfGraph)((Object)this.getGraph());
        } else if (this.getGraph() instanceof OntModel && (m3 = (OntModel)((Object)this.getGraph())).getGraph() instanceof InfGraph) {
            ig = (InfGraph)m3.getGraph();
        }
        if (ig != null && ig.getReasoner().supportsProperty(ReasonerVocabulary.directSubClassOf)) {
            return this.hasPropertyValue(ReasonerVocabulary.directSubClassOf, "direct sub-class", cls);
        }
        return this.hasSuperClassDirect(cls);
    }

    @Override
    public void removeSuperClass(Resource cls) {
        this.removePropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    @Override
    public void setSubClass(Resource cls) {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator i2 = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        while (i2.hasNext()) {
            i2.removeNext();
        }
        cls.as(OntClass.class).addSuperClass(this);
    }

    @Override
    public void addSubClass(Resource cls) {
        cls.as(OntClass.class).addSuperClass(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntClass getSubClass() {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        try (StmtIterator i2 = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);){
            if (i2.hasNext()) {
                OntClass ontClass = i2.nextStatement().getSubject().as(OntClass.class);
                return ontClass;
            }
            OntClass ontClass = null;
            return ontClass;
        }
    }

    @Override
    public ExtendedIterator<OntClass> listSubClasses() {
        return this.listSubClasses(false);
    }

    @Override
    public ExtendedIterator<OntClass> listSubClasses(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), direct, true).filterDrop(new OntResourceImpl.SingleEqualityFilter<OntClassImpl>(this, this)).filterKeep(new UniqueFilter());
    }

    @Override
    public boolean hasSubClass(Resource cls) {
        return this.hasSubClass(cls, false);
    }

    @Override
    public boolean hasSubClass() {
        return this.getSubClass() != null;
    }

    @Override
    public boolean hasSubClass(Resource cls, boolean direct) {
        if (this.getModel() instanceof OntModel && (cls.getModel() == null || !(cls.getModel() instanceof OntModel))) {
            cls = cls.inModel(this.getModel());
        }
        return cls.as(OntClass.class).hasSuperClass(this, direct);
    }

    @Override
    public void removeSubClass(Resource cls) {
        cls.as(OntClass.class).removeSuperClass(this);
    }

    @Override
    public void setEquivalentClass(Resource cls) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    @Override
    public void addEquivalentClass(Resource cls) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    @Override
    public OntClass getEquivalentClass() {
        return this.objectAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class);
    }

    @Override
    public ExtendedIterator<OntClass> listEquivalentClasses() {
        return this.listAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public boolean hasEquivalentClass(Resource cls) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    @Override
    public void removeEquivalentClass(Resource cls) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    @Override
    public void setDisjointWith(Resource cls) {
        this.setPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    @Override
    public void addDisjointWith(Resource cls) {
        this.addPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    @Override
    public OntClass getDisjointWith() {
        return this.objectAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class);
    }

    @Override
    public ExtendedIterator<OntClass> listDisjointWith() {
        return this.listAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public boolean isDisjointWith(Resource cls) {
        return this.hasPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    @Override
    public void removeDisjointWith(Resource cls) {
        this.removePropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    @Override
    public ExtendedIterator<OntProperty> listDeclaredProperties() {
        return this.listDeclaredProperties(false);
    }

    @Override
    public ExtendedIterator<OntProperty> listDeclaredProperties(boolean direct) {
        HashSet<Property> candSet = new HashSet<Property>();
        ExtendedIterator<Statement> i2 = this.listAllProperties();
        while (i2.hasNext()) {
            candSet.add(((Statement)i2.next()).getSubject().as(Property.class));
        }
        ArrayList<Property> cands = new ArrayList<Property>();
        cands.addAll(candSet);
        for (int j = cands.size() - 1; j >= 0; --j) {
            Property cand = (Property)cands.get(j);
            if (this.hasDeclaredProperty(cand, direct)) continue;
            cands.remove(j);
        }
        return WrappedIterator.create(cands.iterator()).mapWith(new OntResourceImpl.AsMapper<OntProperty>(OntProperty.class));
    }

    @Override
    public boolean hasDeclaredProperty(Property p, boolean direct) {
        return this.testDomain(p, direct);
    }

    public ExtendedIterator<Individual> listInstances() {
        return this.listInstances(false);
    }

    public ExtendedIterator<Individual> listInstances(final boolean direct) {
        return this.getModel().listStatements(null, RDF.type, this).mapWith(new OntResourceImpl.SubjectAsMapper<Individual>(Individual.class)).filterKeep(new Filter<Individual>(){

            @Override
            public boolean accept(Individual o) {
                return o.hasRDFType(OntClassImpl.this, direct);
            }
        }).filterKeep(new UniqueFilter());
    }

    @Override
    public Individual createIndividual() {
        return ((OntModel)this.getModel()).createIndividual(this);
    }

    @Override
    public Individual createIndividual(String uri) {
        return ((OntModel)this.getModel()).createIndividual(uri, this);
    }

    @Override
    public void dropIndividual(Resource individual) {
        this.getModel().remove(individual, RDF.type, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHierarchyRoot() {
        if (this.equals(this.getProfile().NOTHING())) {
            return false;
        }
        try (ExtendedIterator<OntClass> i2 = this.listSuperClasses(true);){
            while (i2.hasNext()) {
                Resource sup = (Resource)i2.next();
                if (sup.equals(this.getProfile().THING()) || sup.equals(RDFS.Resource) || sup.equals(this)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public EnumeratedClass asEnumeratedClass() {
        return this.as(EnumeratedClass.class);
    }

    @Override
    public UnionClass asUnionClass() {
        return this.as(UnionClass.class);
    }

    @Override
    public IntersectionClass asIntersectionClass() {
        return this.as(IntersectionClass.class);
    }

    @Override
    public ComplementClass asComplementClass() {
        return this.as(ComplementClass.class);
    }

    @Override
    public Restriction asRestriction() {
        return this.as(Restriction.class);
    }

    @Override
    public boolean isEnumeratedClass() {
        this.checkProfile(this.getProfile().ONE_OF(), "ONE_OF");
        return this.hasProperty(this.getProfile().ONE_OF());
    }

    @Override
    public boolean isUnionClass() {
        this.checkProfile(this.getProfile().UNION_OF(), "UNION_OF");
        return this.hasProperty(this.getProfile().UNION_OF());
    }

    @Override
    public boolean isIntersectionClass() {
        this.checkProfile(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.hasProperty(this.getProfile().INTERSECTION_OF());
    }

    @Override
    public boolean isComplementClass() {
        this.checkProfile(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.hasProperty(this.getProfile().COMPLEMENT_OF());
    }

    @Override
    public boolean isRestriction() {
        this.checkProfile(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.hasProperty(this.getProfile().ON_PROPERTY()) || this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    @Override
    public EnumeratedClass convertToEnumeratedClass(RDFList individuals) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", individuals);
        return this.as(EnumeratedClass.class);
    }

    @Override
    public IntersectionClass convertToIntersectionClass(RDFList classes) {
        this.setPropertyValue(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF", classes);
        return this.as(IntersectionClass.class);
    }

    @Override
    public UnionClass convertToUnionClass(RDFList classes) {
        this.setPropertyValue(this.getProfile().UNION_OF(), "UNION_OF", classes);
        return this.as(UnionClass.class);
    }

    @Override
    public ComplementClass convertToComplementClass(Resource cls) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
        return this.as(ComplementClass.class);
    }

    @Override
    public Restriction convertToRestriction(Property prop) {
        if (!this.hasRDFType(this.getProfile().RESTRICTION(), "RESTRICTION", false)) {
            this.setRDFType(this.getProfile().RESTRICTION());
        }
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
        return this.as(Restriction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSuperClassDirect(Resource cls) {
        try (ExtendedIterator<OntClass> i2 = this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "subClassOf", OntClass.class, this.getProfile().SUB_CLASS_OF(), true, false);){
            while (i2.hasNext()) {
                if (!cls.equals(i2.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected boolean testDomain(Property p, boolean direct) {
        String namespace2 = p.getNameSpace();
        for (String IGNORE_NAMESPACE : IGNORE_NAMESPACES) {
            if (!namespace2.equals(IGNORE_NAMESPACE)) continue;
            return false;
        }
        boolean isGlobal = true;
        boolean seenDirect = false;
        StmtIterator i2 = this.getModel().listStatements((Resource)p, this.getProfile().DOMAIN(), (RDFNode)null);
        while (i2.hasNext()) {
            Resource domain = i2.nextStatement().getResource();
            if (domain.equals(this.getProfile().THING()) || domain.equals(RDFS.Resource)) continue;
            isGlobal = false;
            if (domain.equals(this)) {
                seenDirect = true;
                continue;
            }
            if (this.canProveSuperClass(domain)) continue;
            return false;
        }
        if (direct) {
            return seenDirect || isGlobal && this.isHierarchyRoot();
        }
        return true;
    }

    protected ExtendedIterator<Statement> listAllProperties() {
        Model caps;
        OntModel mOnt = (OntModel)this.getModel();
        Profile prof = mOnt.getProfile();
        ExtendedIterator<Statement> pi2 = mOnt.listStatements(null, RDF.type, this.getProfile().PROPERTY());
        if (mOnt.getReasoner() != null && (caps = mOnt.getReasoner().getReasonerCapabilities()).contains(null, ReasonerVocabulary.supportsP, OWL.ObjectProperty)) {
            return pi2;
        }
        if (prof.OBJECT_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.OBJECT_PROPERTY()));
        }
        if (prof.DATATYPE_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.DATATYPE_PROPERTY()));
        }
        if (prof.FUNCTIONAL_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.FUNCTIONAL_PROPERTY()));
        }
        if (prof.INVERSE_FUNCTIONAL_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.INVERSE_FUNCTIONAL_PROPERTY()));
        }
        if (prof.SYMMETRIC_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.SYMMETRIC_PROPERTY()));
        }
        if (prof.TRANSITIVE_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.TRANSITIVE_PROPERTY()));
        }
        if (prof.ANNOTATION_PROPERTY() != null) {
            pi2 = pi2.andThen(mOnt.listStatements(null, RDF.type, prof.ANNOTATION_PROPERTY()));
        }
        return pi2;
    }

    protected boolean canProveSuperClass(Resource sup) {
        OntModel om = (OntModel)this.getModel();
        if (om.getReasoner() != null && om.getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, RDFS.subClassOf)) {
            return this.hasSuperClass(sup);
        }
        HashSet<OntClass> seen = new HashSet<OntClass>();
        ArrayList<OntClassImpl> queue = new ArrayList<OntClassImpl>();
        queue.add(this);
        while (!queue.isEmpty()) {
            OntClass c = (OntClass)queue.remove(0);
            if (seen.contains(c)) continue;
            seen.add(c);
            if (c.equals(sup)) {
                return true;
            }
            ExtendedIterator<OntClass> i2 = c.listSuperClasses();
            while (i2.hasNext()) {
                queue.add((OntClassImpl)i2.next());
            }
        }
        return false;
    }
}

