/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StatementBoundary;

public class ModelExtract {
    protected StatementBoundary boundary;

    public ModelExtract(StatementBoundary b) {
        this.boundary = b;
    }

    public Model extract(Resource r, Model s2) {
        return this.extractInto(ModelFactory.createDefaultModel(), r, s2);
    }

    public Model extractInto(Model model, Resource r, Model s2) {
        TripleBoundary tb = this.boundary.asTripleBoundary(s2);
        Graph g2 = this.getGraphExtract(tb).extractInto(model.getGraph(), r.asNode(), s2.getGraph());
        return ModelFactory.createModelForGraph(g2);
    }

    protected GraphExtract getGraphExtract(TripleBoundary tb) {
        return new GraphExtract(tb);
    }
}

