/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput.impl;

import com.hp.hpl.jena.rdfxml.xmlinput.impl.QNameLexer;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.Taint;
import com.hp.hpl.jena.rdfxml.xmlinput.states.Frame;
import org.xml.sax.SAXParseException;

public class ElementLexer
extends QNameLexer {
    private final String uri;
    private final String localName;
    private final String qname;
    public final boolean goodMatch;
    public final boolean badMatch;

    public ElementLexer(Taint t, Frame f, String uri, String localName, String qname, int good, int bad, boolean report_1) throws SAXParseException {
        super(f, good, bad);
        this.uri = uri;
        this.localName = localName;
        this.qname = qname;
        int match = this.lookup(t);
        this.goodMatch = (good & match) != 0;
        boolean bl = this.badMatch = (this.bad & match) != 0;
        if (!this.goodMatch && !this.badMatch && (this.bad & 0x1000) == 4096 && rdfns.equals(uri)) {
            if (ElementLexer.isMemberProperty(localName)) {
                if (report_1) {
                    this.frame.warning(t, 114, qname + " is being used on a typed node.");
                }
            } else if (!ElementLexer.isKnownNonMemberRDFProperty(localName)) {
                this.frame.warning(t, 113, qname + " is not a recognized RDF property or type.");
            }
        }
    }

    @Override
    boolean isInRdfns(Taint me) {
        return rdfns.equals(this.getUri());
    }

    @Override
    void error(Taint me, int r) throws SAXParseException {
        this.frame.warning(me, r == 2048 ? 204 : 205, this.getQName() + " is not allowed as an element tag here.");
    }

    @Override
    void deprecatedAttribute(Taint me, int r) throws SAXParseException {
        this.error(me, r);
    }

    @Override
    String getLocalName() {
        return this.localName;
    }

    @Override
    String getUri() {
        return this.uri;
    }

    @Override
    String getQName() {
        return this.qname;
    }

    @Override
    void bagIDAttribute(Taint taintMe, int rslt) throws SAXParseException {
        this.error(taintMe, rslt);
    }
}

