/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class StrConcat
extends BaseBuiltin {
    @Override
    public String getName() {
        return "strConcat";
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 1) {
            throw new BuiltinException(this, context, "Must have at least 1 argument to " + this.getName());
        }
        StringBuilder buff = new StringBuilder();
        for (int i2 = 0; i2 < length - 1; ++i2) {
            buff.append(this.lex(this.getArg(i2, args, context), context));
        }
        Node result = NodeFactory.createLiteral(buff.toString());
        return context.getEnv().bind(args[length - 1], result);
    }

    protected String lex(Node n, RuleContext context) {
        if (n.isBlank()) {
            return n.getBlankNodeLabel();
        }
        if (n.isURI()) {
            return n.getURI();
        }
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context, "Illegal node type: " + n);
    }
}

