/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.util.iterator.ClosableIterator;

public class BBRuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected BackwardRuleInfGraphI graph;

    public BBRuleContext(BackwardRuleInfGraphI graph) {
        this.graph = graph;
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        ClosableIterator<Triple> i2 = this.find(s2, p, o);
        boolean result = i2.hasNext();
        i2.close();
        return result;
    }

    @Override
    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public ClosableIterator<Triple> find(Node s2, Node p, Node o) {
        return this.graph.findDataMatches(new TriplePattern(s2, p, o));
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    @Override
    public void add(Triple t) {
        this.graph.silentAdd(t);
    }

    @Override
    public void remove(Triple t) {
        this.graph.delete(t);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.graph.getTemp(instance, prop, pclass);
    }
}

