/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path.eval;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.eval.PathEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jena.atlas.iterator.Iter;

final class PathEngine1
extends PathEngine {
    private boolean forwardMode;

    public PathEngine1(Graph graph, boolean forward) {
        super(graph, null);
        this.forwardMode = forward;
    }

    @Override
    protected Collection<Node> collector() {
        return new ArrayList<Node>();
    }

    @Override
    protected void flipDirection() {
        this.forwardMode = !this.forwardMode;
    }

    @Override
    protected boolean direction() {
        return this.forwardMode;
    }

    @Override
    protected void doAlt(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        HashSet<Node> nodes = new HashSet<Node>();
        this.eval(pathStepLeft, node, nodes);
        this.eval(pathStepRight, node, nodes);
        output.addAll(nodes);
    }

    @Override
    protected void doSeq(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        Path part1 = this.forwardMode ? pathStepLeft : pathStepRight;
        Path part2 = this.forwardMode ? pathStepRight : pathStepLeft;
        Collection<Node> nodes = this.collector();
        this.eval(part1, node, nodes);
        HashSet<Node> nodes2 = new HashSet<Node>();
        for (Node n : nodes) {
            this.eval(part2, n, nodes2);
        }
        output.addAll(nodes2);
    }

    private static void fillUnique(Iterator<Node> nodes, Collection<Node> acc) {
        while (nodes.hasNext()) {
            Node n = nodes.next();
            if (acc.contains(n)) continue;
            acc.add(n);
        }
    }

    @Override
    protected void doMultiLengthPath(Path pathStep, Node node, long min1, long max1, Collection<Node> output) {
        if (min1 == -1L) {
            min1 = 0L;
        }
        Collection<Node> collectStartPoints = this.collector();
        if (min1 > 0L) {
            this.doFixedLengthPath(pathStep, node, min1, collectStartPoints);
        } else {
            collectStartPoints.add(node);
        }
        int length = (int)(max1 - min1);
        Collection<Node> visited = this.collector();
        for (Node n : collectStartPoints) {
            this.doMultiLengthPath(pathStep, n, (long)length, visited, output);
        }
    }

    protected void doMultiLengthPath(Path pathStep, Node node, long length, Collection<Node> visited, Collection<Node> output) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        output.add(node);
        if (length == 0L) {
            return;
        }
        Iter<Node> iter = this.eval(pathStep, node);
        while (iter.hasNext()) {
            Node m3 = (Node)iter.next();
            if (visited.contains(m3)) continue;
            this.doMultiLengthPath(pathStep, m3, length - 1L, visited, output);
        }
    }

    @Override
    protected void doFixedLengthPath(Path pathStep, Node node, long fixedLength, Collection<Node> output) {
        Collection<Node> visited = this.collector();
        if (fixedLength == 0L) {
            this.doZero(pathStep, node, output);
            return;
        }
        if (fixedLength == 1L) {
            Iter<Node> iter = this.eval(pathStep, node);
            for (Node n : iter) {
                if (output.contains(n)) continue;
                output.add(n);
            }
            return;
        }
        Iter<Node> iter = this.eval(pathStep, node);
        for (Node n : iter) {
            this.doFixedLengthPath(pathStep, n, fixedLength - 1L, output);
        }
    }

    @Override
    protected void doZeroOrMore(Path path, Node node, Collection<Node> output) {
        LinkedList<Node> visited = new LinkedList<Node>();
        this.ALP1(this.forwardMode, 0, -1, node, path, visited);
        output.addAll(visited);
    }

    @Override
    protected void doOneOrMore(Path path, Node node, Collection<Node> output) {
        LinkedList<Node> visited = new LinkedList<Node>();
        Iter<Node> iter1 = this.eval(path, node);
        while (iter1.hasNext()) {
            Node n1 = iter1.next();
            this.ALP1(this.forwardMode, 0, -1, n1, path, visited);
        }
        output.addAll(visited);
    }

    private void ALP1(boolean forwardMode, int stepCount, int maxStepCount, Node node, Path path, Collection<Node> visited) {
        if (maxStepCount >= 0 && stepCount > maxStepCount) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        if (!visited.add(node)) {
            return;
        }
        Iter<Node> iter1 = this.eval(path, node);
        while (iter1.hasNext()) {
            Node n1 = iter1.next();
            this.ALP1(forwardMode, stepCount + 1, maxStepCount, n1, path, visited);
        }
    }

    @Override
    protected void doNegatedPropertySet(P_NegPropSet pathNotOneOf, Node node, Collection<Node> output) {
        if (pathNotOneOf.getFwdNodes().size() > 0) {
            Iterator<Node> nodes1 = this.stepExcludeForwards(node, pathNotOneOf.getFwdNodes());
            PathEngine1.fillUnique(nodes1, output);
        }
        if (pathNotOneOf.getBwdNodes().size() > 0) {
            Iterator<Node> nodes2 = this.stepExcludeBackwards(node, pathNotOneOf.getBwdNodes());
            PathEngine1.fillUnique(nodes2, output);
        }
    }

    @Override
    protected void doZeroOrOne(Path pathStep, Node node, Collection<Node> output) {
        this.eval(pathStep, node, output);
        if (!output.contains(node)) {
            output.add(node);
        }
    }

    @Override
    protected void doZero(Path path, Node node, Collection<Node> output) {
        if (!output.contains(node)) {
            output.add(node);
        }
    }
}

