/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.RValue;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RomanNumeral {
    int intValue;
    static String numeralPattern = "M*(CM|DC{0,3}|CD|C{0,3})(XC|LX{0,3}|XL|X{0,3})(IX|VI{0,3}|IV|I{0,4})";
    static Pattern pattern = Pattern.compile(numeralPattern);

    public static void main(String[] args) {
        RomanNumeral.roman("I");
        RomanNumeral.roman("IV");
        RomanNumeral.roman("IIII");
        RomanNumeral.roman("IIIII");
        RomanNumeral.roman("IIIIV");
        RomanNumeral.roman("XL");
        RomanNumeral.roman("XD");
        RomanNumeral.roman("XMIX");
        RomanNumeral.roman("MIM");
        RomanNumeral.roman("MCMXCIX");
    }

    public static void roman(String lex) {
        int i2 = RomanNumeral.r2i(lex);
        System.out.print(lex + " ==> " + i2 + " ==> " + RomanNumeral.i2r(i2) + " ==> " + RomanNumeral.r2i(RomanNumeral.i2r(i2)));
        System.out.print("  Valid: " + RomanNumeral.isValid(lex));
        System.out.println();
    }

    public RomanNumeral(String lexicalForm) {
        if (!RomanNumeral.isValid(lexicalForm)) {
            throw new NumberFormatException("Invalid Roman Numeral: " + lexicalForm);
        }
        this.intValue = RomanNumeral.r2i(lexicalForm);
    }

    public RomanNumeral(int i2) {
        if (i2 <= 0) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i2 + ")");
        }
        if (i2 > 3999) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i2 + ")");
        }
        this.intValue = i2;
    }

    public String toString() {
        return RomanNumeral.i2r(this.intValue);
    }

    public int intValue() {
        return this.intValue;
    }

    public static boolean isValid(String lex) {
        lex = lex.toUpperCase(Locale.ENGLISH);
        Matcher m3 = pattern.matcher(lex);
        return m3.matches();
    }

    public static int parse(String lex) {
        return RomanNumeral.r2i(lex);
    }

    public static int r2i(String lex) {
        lex = lex.toUpperCase(Locale.ROOT);
        int current = 0;
        int v = 0;
        for (int i2 = lex.length() - 1; i2 >= 0; --i2) {
            char ch = lex.charAt(i2);
            int x = RomanNumeral.charToNum(ch);
            if (x < current) {
                v -= x;
                continue;
            }
            v += x;
            current = x;
        }
        return v;
    }

    public static String asRomanNumerals(int i2) {
        return RomanNumeral.i2r(i2);
    }

    public static String i2r(int i2) {
        if (i2 <= 0) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i2 + ")");
        }
        if (i2 > 3999) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i2 + ")");
        }
        StringBuffer sbuff = new StringBuffer();
        i2 = RomanNumeral.i2r(sbuff, i2, "M", 1000, "CM", 900, "D", 500, "CD", 400);
        i2 = RomanNumeral.i2r(sbuff, i2, "C", 100, "XC", 90, "L", 50, "XL", 40);
        for (i2 = RomanNumeral.i2r(sbuff, i2, "X", 10, "IX", 9, "V", 5, "IV", 4); i2 >= 1; --i2) {
            sbuff.append("I");
        }
        return sbuff.toString();
    }

    private static int i2r(StringBuffer sbuff, int i2, String tens, int iTens, String nines, int iNines, String fives, int iFives, String fours, int iFours) {
        while (i2 >= iTens) {
            sbuff.append(tens);
            i2 -= iTens;
        }
        if (i2 >= iNines) {
            sbuff.append(nines);
            i2 -= iNines;
        }
        if (i2 >= iFives) {
            sbuff.append(fives);
            i2 -= iFives;
        }
        if (i2 >= iFours) {
            sbuff.append(fours);
            i2 -= iFours;
        }
        return i2;
    }

    private static int charToNum(char ch) {
        if (ch == '\u0000') {
            return 0;
        }
        for (int i2 = 0; i2 < RValue.table.length; ++i2) {
            if (RValue.table[i2].lex != ch) continue;
            return RValue.table[i2].val;
        }
        return 0;
    }
}

