/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.cache;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.cache.Cache;

public class EnhancedNodeCache
implements Cache {
    protected String name;
    protected EnhNode[] elements;
    protected boolean enabled = true;
    protected long gets;
    protected long puts;
    protected long hits;

    public EnhancedNodeCache(String name, int size) {
        this.name = name;
        this.elements = new EnhNode[size];
    }

    @Override
    public Object get(Object key) {
        if (this.enabled) {
            ++this.gets;
            Node n = (Node)key;
            int i2 = this.hashNode(n);
            EnhNode result = this.elements[i2];
            if (result != null && result.asNode().equals(key)) {
                ++this.hits;
                return result;
            }
        }
        return null;
    }

    @Override
    public void put(Object key, Object value) {
        if (this.enabled) {
            ++this.puts;
            Node n = (Node)key;
            int i2 = this.hashNode(n);
            this.elements[i2] = (EnhNode)value;
        }
    }

    protected int hashNode(Node n) {
        return (n.hashCode() & Integer.MAX_VALUE) % this.elements.length;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public boolean setEnabled(boolean enabled) {
        boolean result = this.enabled;
        this.enabled = enabled;
        return result;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            this.elements[i2] = null;
        }
    }

    @Override
    public long getGets() {
        return this.gets;
    }

    @Override
    public long getPuts() {
        return this.puts;
    }

    @Override
    public long getHits() {
        return this.hits;
    }
}

