/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class DigestAlgorithm {
    public static final DigestAlgorithm md5 = new DigestAlgorithm("md5", "md5");
    public static final DigestAlgorithm sha1 = new DigestAlgorithm("sha1", "sha-1");
    public static final DigestAlgorithm sha256 = new DigestAlgorithm("sha256", "sha-256");
    public static final DigestAlgorithm sha512 = new DigestAlgorithm("sha512", "sha-512");
    public static final DigestAlgorithm blake2b512 = new DigestAlgorithm("blake2b-512", "blake2b-512");
    public static final DigestAlgorithm blake2b160 = new DigestAlgorithm("blake2b-160", "blake2b-160");
    public static final DigestAlgorithm blake2b256 = new DigestAlgorithm("blake2b-256", "blake2b-256");
    public static final DigestAlgorithm blake2b384 = new DigestAlgorithm("blake2b-384", "blake2b-384");
    public static final DigestAlgorithm sha512_256 = new DigestAlgorithm("sha512/256", "sha-512/256");
    private final String ocflName;
    private final String javaStandardName;

    @JsonCreator
    public static DigestAlgorithm fromOcflName(String ocflName) {
        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm(ocflName);
        if (algorithm == null) {
            algorithm = new DigestAlgorithm(ocflName, null);
        }
        return algorithm;
    }

    public static DigestAlgorithm fromOcflName(String ocflName, String javaStandardName) {
        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm(ocflName);
        if (algorithm == null) {
            algorithm = new DigestAlgorithm(ocflName, javaStandardName);
        }
        return algorithm;
    }

    private DigestAlgorithm(String ocflName, String javaStandardName) {
        this.ocflName = Enforce.notBlank(ocflName, "ocflName cannot be blank").toLowerCase();
        this.javaStandardName = javaStandardName;
    }

    @JsonValue
    public String getOcflName() {
        return this.ocflName;
    }

    public String getJavaStandardName() {
        return this.javaStandardName;
    }

    public boolean hasJavaStandardName() {
        return this.javaStandardName != null;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.javaStandardName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OcflJavaException("Failed to create message digest for: " + this, e2);
        }
    }

    public String toString() {
        return "DigestAlgorithm{ocflName='" + this.ocflName + "', javaStandardName='" + this.javaStandardName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigestAlgorithm that = (DigestAlgorithm)o;
        return this.ocflName.equals(that.ocflName);
    }

    public int hashCode() {
        return Objects.hash(this.ocflName);
    }
}

