/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public enum DbType {
    POSTGRES("PostgreSQL"),
    H2("H2");

    private String productName;

    private DbType(String productName) {
        this.productName = productName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DbType fromDataSource(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            String productName = connection.getMetaData().getDatabaseProductName();
            for (DbType type : DbType.values()) {
                if (!type.productName.equals(productName)) continue;
                DbType dbType = type;
                return dbType;
            }
            throw new OcflJavaException(String.format("%s is not mapped to a DbType.", productName));
        }
        catch (SQLException e2) {
            throw new OcflDbException(e2);
        }
    }
}

