/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import edu.wisc.library.ocfl.api.exception.InvalidVersionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.Objects;
import java.util.regex.Pattern;

public class RevisionNum
implements Comparable<RevisionNum> {
    public static final RevisionNum R1 = new RevisionNum(1L);
    private static final Pattern VALID_REVISION = Pattern.compile("^r\\d+$");
    private final long revisionNumber;
    private final long maxRevision;
    private final String stringValue;

    public static boolean isRevisionNum(String value) {
        return VALID_REVISION.matcher(value).matches();
    }

    public static RevisionNum fromString(String value) {
        if (!VALID_REVISION.matcher(value).matches()) {
            throw new InvalidVersionException("Invalid RevisionNum: " + value);
        }
        String numPart = value.substring(1);
        return new RevisionNum(Long.parseLong(numPart));
    }

    public static RevisionNum fromInt(int revisionNumber) {
        return new RevisionNum(revisionNumber);
    }

    public RevisionNum(long revisionNumber) {
        this.revisionNumber = Enforce.expressionTrue(revisionNumber > 0L, revisionNumber, "revisionNumber must be greater than 0");
        this.stringValue = "r" + revisionNumber;
        this.maxRevision = Long.MAX_VALUE;
    }

    public RevisionNum nextRevisionNum() {
        long nextVersionNum = this.revisionNumber + 1L;
        if (nextVersionNum > this.maxRevision) {
            throw new InvalidVersionException("Cannot increment revision number. Current revision " + this.toString() + " is the highest possible.");
        }
        return new RevisionNum(nextVersionNum);
    }

    public RevisionNum previousRevisionNum() {
        if (this.revisionNumber == 1L) {
            throw new InvalidVersionException("Cannot decrement revision number. Current revision " + this.toString() + " is the lowest possible.");
        }
        return new RevisionNum(this.revisionNumber - 1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionNum revisionNum = (RevisionNum)o;
        return Objects.equals(this.stringValue, revisionNum.stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    @Override
    public int compareTo(RevisionNum o) {
        return Long.compare(this.revisionNumber, o.revisionNumber);
    }
}

