/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.exception.PathConstraintException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;

public class BeginEndPathConstraint
implements PathConstraint,
FileNameConstraint {
    private final boolean mustMatch;
    private final Type type;
    private final String value;

    public static BeginEndPathConstraint mustNotEndWith(String suffix) {
        return new BeginEndPathConstraint(false, Type.END, suffix);
    }

    public static BeginEndPathConstraint mustEndWith(String suffix) {
        return new BeginEndPathConstraint(true, Type.END, suffix);
    }

    public static BeginEndPathConstraint mustNotBeginWith(String prefix) {
        return new BeginEndPathConstraint(false, Type.BEGIN, prefix);
    }

    public static BeginEndPathConstraint mustBeginWith(String prefix) {
        return new BeginEndPathConstraint(true, Type.BEGIN, prefix);
    }

    private BeginEndPathConstraint(boolean mustMatch, Type type, String value) {
        this.mustMatch = mustMatch;
        this.type = Enforce.notNull(type, "type cannot be null");
        this.value = Enforce.notBlank(value, "value cannot be blank");
    }

    @Override
    public void apply(String path) {
        if (this.type.matches(this.value, path)) {
            if (!this.mustMatch) {
                throw new PathConstraintException(String.format("The path must not %s with %s. Path: %s", new Object[]{this.type, this.value, path}));
            }
        } else if (this.mustMatch) {
            throw new PathConstraintException(String.format("The path must %s with %s but does not. Path: %s", new Object[]{this.type, this.value, path}));
        }
    }

    @Override
    public void apply(String fileName, String path) {
        if (this.type.matches(this.value, fileName)) {
            if (!this.mustMatch) {
                throw new PathConstraintException(String.format("The filename '%s' must not %s with %s. Path: %s", new Object[]{fileName, this.type, this.value, path}));
            }
        } else if (this.mustMatch) {
            throw new PathConstraintException(String.format("The filename '%s' must %s with %s but does not. Path: %s", new Object[]{fileName, this.type, this.value, path}));
        }
    }

    private static enum Type {
        BEGIN{

            @Override
            boolean matches(String value, String path) {
                return path.startsWith(value);
            }
        }
        ,
        END{

            @Override
            boolean matches(String value, String path) {
                return path.endsWith(value);
            }
        };


        abstract boolean matches(String var1, String var2);
    }
}

