/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CountingCircuitStats;
import net.jodah.failsafe.internal.DefaultCircuitStats;
import net.jodah.failsafe.internal.TimedCircuitStats;

public interface CircuitStats {
    public static CircuitStats create(CircuitBreaker breaker, int capacity, boolean supportsTimeBased, CircuitStats oldStats) {
        if (supportsTimeBased && breaker.getFailureThresholdingPeriod() != null) {
            return new TimedCircuitStats(10, breaker.getFailureThresholdingPeriod(), new TimedCircuitStats.Clock(), oldStats);
        }
        if (capacity > 1) {
            return new CountingCircuitStats(capacity, oldStats);
        }
        return new DefaultCircuitStats();
    }

    default public void copyExecutions(CircuitStats oldStats) {
        int i2;
        for (i2 = 0; i2 < oldStats.getSuccessCount(); ++i2) {
            this.recordSuccess();
        }
        for (i2 = 0; i2 < oldStats.getFailureCount(); ++i2) {
            this.recordSuccess();
        }
    }

    public int getFailureCount();

    public int getExecutionCount();

    public int getSuccessCount();

    public int getFailureRate();

    public int getSuccessRate();

    public void recordFailure();

    public void recordSuccess();
}

