/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.NotImplemented;

public class BlockUTF8 {
    public static void toChars(ByteBuffer bb, CharBuffer cb) {
        BlockUTF8.toCharsBuffer(bb, cb);
    }

    public static void fromChars(CharBuffer cb, ByteBuffer bb) {
        BlockUTF8.fromCharsBuffer(cb, bb);
    }

    public static String toString(ByteBuffer bb) {
        int len = bb.remaining();
        CharBuffer cb = CharBuffer.allocate(len);
        BlockUTF8.toChars(bb, cb);
        return new String(cb.array(), 0, cb.position());
    }

    private static void toCharsBuffer(ByteBuffer bb, CharBuffer cb) {
        int idx = bb.position();
        int limit = bb.limit();
        while (idx < limit) {
            int ch;
            byte x = bb.get();
            if (x > 0 && x <= 127) {
                cb.put((char)x);
                ++idx;
                continue;
            }
            if (x == 0) {
                cb.put((char)x);
                ++idx;
                continue;
            }
            if ((x & 0xE0) == 192) {
                byte x2 = bb.get();
                if ((x2 & 0xC0) != 128) {
                    BlockUTF8.exception("Illegal UTF-8 processing character: 0x%04X", x2);
                }
                int ch2 = (x & 0x1F) << 6 | x2 & 0x3F;
                cb.put((char)ch2);
                idx += 2;
                continue;
            }
            if ((x & 0xF0) == 224) {
                ch = BlockUTF8.readMultiBytes(bb, x & 0xF, 3);
                cb.put((char)ch);
                idx += 3;
                continue;
            }
            if ((x & 0xF8) == 240) {
                ch = BlockUTF8.readMultiBytes(bb, x & 8, 4);
                char[] chars = Character.toChars(ch);
                cb.put(chars);
                idx += 4;
                continue;
            }
            BlockUTF8.exception("Illegal UTF-8: 0x%04X", x);
            return;
        }
    }

    private static void toCharsArray(byte[] bytes, char[] chars) {
        throw new NotImplemented();
    }

    private static void fromCharsBuffer(CharBuffer cb, ByteBuffer bb) {
        int limit = cb.limit();
        for (int idx = cb.position(); idx < limit; ++idx) {
            int x2;
            int x1;
            char ch = cb.get();
            if (ch != '\u0000' && ch <= '\u007f') {
                bb.put((byte)ch);
                continue;
            }
            if (ch == '\u0000') {
                bb.put((byte)0);
                continue;
            }
            if (ch <= '\u07ff') {
                x1 = ch >> 6 & 0x1F | 0xC0;
                x2 = ch & 0x3F | 0x80;
                bb.put((byte)x1);
                bb.put((byte)x2);
                continue;
            }
            if (ch <= '\uffff') {
                x1 = ch >> 12 & 0xF | 0xE0;
                x2 = ch >> 6 & 0x3F | 0x80;
                int x3 = ch & 0x3F | 0x80;
                bb.put((byte)x1);
                bb.put((byte)x2);
                bb.put((byte)x3);
                continue;
            }
            if (ch <= '\u1fffff') {
                x1 = ch >> 18 & 7 | 0xF0;
                BlockUTF8.outputBytes(bb, x1, 4, ch);
                continue;
            }
            if (ch <= '\u3ffffff') {
                x1 = ch >> 24 & 3 | 0xF8;
                BlockUTF8.outputBytes(bb, x1, 5, ch);
                continue;
            }
            if (ch > Integer.MAX_VALUE) continue;
            x1 = ch >> 31 & 1 | 0xFC;
            BlockUTF8.outputBytes(bb, x1, 6, ch);
        }
    }

    private static void fromCharsArray(char[] array, byte[] array2) {
        throw new NotImplemented();
    }

    public static void fromChars(CharSequence cs, ByteBuffer bb) {
        BlockUTF8.fromChars(CharBuffer.wrap(cs), bb);
    }

    private static int readMultiBytes(ByteBuffer input, int start, int len) {
        if (input.remaining() < len - 1) {
            BlockUTF8.exception("Premature end to UTF-8 sequence at end of input", new Object[0]);
        }
        int x = start;
        for (int i2 = 0; i2 < len - 1; ++i2) {
            byte x2 = input.get();
            if ((x2 & 0xC0) != 128) {
                BlockUTF8.exception("Illegal UTF-8 processing character: 0x%04X", x2);
            }
            x = x << 6 | x2 & 0x3F;
        }
        return x;
    }

    private static void outputBytes(ByteBuffer bb, int x1, int byteLength, int ch) {
        bb.put((byte)x1);
        --byteLength;
        for (int i2 = 0; i2 < byteLength; ++i2) {
            int shift = 6 * (byteLength - i2 - 1);
            int x = ch >> shift & 0x3F;
            bb.put((byte)(x |= 0x80));
        }
    }

    private static void exception(String fmt, Object ... args) {
        String str2 = String.format(fmt, args);
        IO.exception(new IOException(str2));
    }
}

