/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.CharStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.InputStreamBuffered;

public final class InStreamUTF8
extends Reader
implements CharStream {
    private InputStreamBuffered input;

    public InStreamUTF8(InputStream in) {
        if (in instanceof InputStreamBuffered) {
            this.input = (InputStreamBuffered)in;
            return;
        }
        this.input = new InputStreamBuffered(in);
    }

    public InStreamUTF8(InputStreamBuffered in) {
        this.input = in;
    }

    @Override
    public boolean ready() throws IOException {
        return this.input.available() > 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void closeStream() {
        IO.close(this.input);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i2 = off; i2 < off + len; ++i2) {
            int x = this.read();
            if (x == -1) {
                if (i2 == off) {
                    return -1;
                }
                return i2 - off;
            }
            cbuf[i2] = (char)x;
        }
        return len;
    }

    @Override
    public final int read() throws IOException {
        int ch = InStreamUTF8.advance(this.input);
        return ch;
    }

    @Override
    public final int advance() {
        return InStreamUTF8.advance(this.input);
    }

    public static final int advance(InputStreamBuffered input) {
        int x = input.advance();
        if (x == -1) {
            return -1;
        }
        return InStreamUTF8.advance(input, x);
    }

    public static final int advance(InputStreamBuffered input, int x) {
        if (x == -1 || x <= 127) {
            return x;
        }
        if ((x & 0xE0) == 192) {
            int ch = InStreamUTF8.readMultiBytes(input, x & 0x1F, 2);
            return ch;
        }
        if ((x & 0xF0) == 224) {
            int ch = InStreamUTF8.readMultiBytes(input, x & 0xF, 3);
            return ch;
        }
        int ch = -2;
        if ((x & 0xF8) == 240) {
            ch = InStreamUTF8.readMultiBytes(input, x & 8, 4);
        } else {
            IO.exception(new IOException("Illegal UTF-8: " + x));
        }
        if (ch > 65535) {
            throw new AtlasException("Out of range character (must use a surrogate pair)");
        }
        if (!Character.isDefined(ch)) {
            throw new AtlasException(String.format("Undefined codepoint: 0x%04X", ch));
        }
        return ch;
    }

    private static int readMultiBytes(InputStreamBuffered input, int start, int len) {
        int x = start;
        for (int i2 = 0; i2 < len - 1; ++i2) {
            int x2 = input.advance();
            if (x2 == -1) {
                throw new AtlasException("Premature end to UTF-8 sequence at end of input");
            }
            if ((x2 & 0xC0) != 128) {
                throw new AtlasException(String.format("Illegal UTF-8 processing character: 0x%04X", x2));
            }
            x = x << 6 | x2 & 0x3F;
        }
        return x;
    }

    private static void p(int ch) {
        System.out.printf(" %02X", ch);
        if (ch == -1) {
            System.out.println();
        }
    }

    public static String decode(byte[] bytes) {
        try {
            char[] chars = new char[bytes.length];
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            StringBuilder buff = new StringBuilder();
            InStreamUTF8 r = new InStreamUTF8(in);
            int len = r.read(chars);
            IO.close(r);
            return new String(chars, 0, len);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }
}

