/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Chars;

public class NumberUtils {
    private static final int[] maxTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public static void formatInt(StringBuilder sb, int value) {
        int len = NumberUtils.length(value);
        NumberUtils.formatInt(sb, value, len, false);
    }

    public static void formatSignedInt(StringBuilder sb, int value) {
        int len = NumberUtils.length(value);
        if (value >= 0) {
            ++len;
        }
        NumberUtils.formatInt(sb, value, len, true);
    }

    static int length(int x) {
        if (x < 0) {
            return NumberUtils.length(-x) + 1;
        }
        int i2 = 0;
        while (x > maxTable[i2]) {
            ++i2;
        }
        return i2 + 1;
    }

    public static void formatInt(StringBuilder sb, int value, int width) {
        NumberUtils.formatInt(sb, value, width, false);
    }

    public static void formatSignedInt(StringBuilder sb, int value, int width) {
        NumberUtils.formatInt(sb, value, width, true);
    }

    public static void formatInt(StringBuilder sb, int value, int width, boolean signAlways) {
        boolean negative;
        boolean bl = negative = value < 0;
        if (negative) {
            value = -value;
            --width;
            sb.append('-');
        } else if (signAlways) {
            --width;
            sb.append('+');
        }
        NumberUtils.formatUnsignedInt(sb, value, width);
    }

    public static void formatUnsignedInt(StringBuilder sb, int value, int width) {
        char[] chars = new char[width];
        NumberUtils.formatUnsignedInt$(chars, value, width);
        for (int i2 = 0; i2 < width; ++i2) {
            sb.append(chars[width - 1 - i2]);
        }
    }

    private static int formatUnsignedInt$(char[] b, int x, int width) {
        int idx = 0;
        while (width > 0) {
            char ch;
            int i2 = x % 10;
            b[idx] = ch = Chars.digits10[i2];
            --width;
            ++idx;
            if ((x /= 10) != 0) continue;
            break;
        }
        if (x != 0) {
            throw new AtlasException("formatInt: overflow[x=" + x + ", width=" + width + "]");
        }
        while (width > 0) {
            b[idx] = 48;
            ++idx;
            --width;
        }
        return width;
    }
}

