/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging.java;

import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TextFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "root";
        }
        int i2 = loggerName.lastIndexOf(46);
        String loggerNameShort = loggerName.substring(i2 + 1);
        String formatted$ = record.getMessage();
        if (record.getParameters() != null) {
            formatted$ = MessageFormat.format(formatted$, record.getParameters());
        }
        return String.format("%5$tT %3$-5s %2$-25s :: %6$s\n", loggerName, loggerNameShort, record.getLevel(), Thread.currentThread().getName(), new Date(record.getMillis()), formatted$);
    }
}

