/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.net.IDN;

public class IDNP {
    public static String toASCII(String host, int flags) {
        if ((flags & 2) != 0) {
            return IDNP.check(IDN.toASCII(host, flags ^ 2));
        }
        return IDN.toASCII(host, flags);
    }

    private static String check(String asciiHost) {
        String[] parts;
        for (String part : parts = asciiHost.split("\\.")) {
            IDNP.checkPart(part);
        }
        return asciiHost;
    }

    private static void checkPart(String part) {
        if (part.charAt(0) == '-' || part.charAt(part.length() - 1) == '-') {
            throw new IllegalArgumentException("Has leading or trailing hyphen");
        }
        for (int i2 = 0; i2 < part.length(); ++i2) {
            char c = part.charAt(i2);
            if (c == '-' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            throw new IllegalArgumentException("Contains non-LDH characters");
        }
    }
}

